﻿<%@ page language="C#" autoeventwireup="true" inherits="ims.users, ims.web" enableviewstatemac="false" enableEventValidation="false" %>
<!DOCTYPE html>
<html id="users">
<head runat="server">
    <title>用户管理</title><meta http-equiv="X-UA-Compatible" content="IE=edge" /><meta name="viewport" content="width=device-width,initial-scale=1"><meta name="format-detection" content="telephone=no">
</head>
<body>
    <form id="form1" runat="server">
    <asp:HiddenField ID="curUserName" runat="server" /><asp:HiddenField ID="curUnit" Value="0" runat="server" />
    <asp:ScriptManager ID="s1" runat="server" EnablePageMethods="True" OnAsyncPostBackError="AsyncError">
        <CompositeScript Path="js/msajax.js" ScriptMode="Release">
            <Scripts>
                <asp:ScriptReference Name="WebForms.js" Assembly="System.Web" /><asp:ScriptReference Name="MicrosoftAjax.js" /><asp:ScriptReference Name="MicrosoftAjaxWebForms.js" />
            </Scripts>
        </CompositeScript>
    </asp:ScriptManager>
    
    <table id="main"><tr><td id="tdUnits" class="vtop">
        <asp:UpdatePanel ID="divUnits" runat="server" UpdateMode="conditional" RenderMode="Block">
        <ContentTemplate>
            <asp:TreeView ID="tv" NodeWrap="false" LineImagesFolder="images/tree" SkipLinkText="" OnSelectedNodeChanged="ShowUnit" SelectedNodeStyle-CssClass="selected" ExpandDepth="1" NodeStyle-HorizontalPadding="3" runat="server" ShowLines="true" CssClass="tree">
                <Nodes>
                    <asp:TreeNode Text="公司" Selected="true" Value="0"></asp:TreeNode>
                    <asp:TreeNode Text="相关操作" SelectAction="Expand">
                        <asp:TreeNode Text="<i class='f-sou'></i>搜索用户" NavigateUrl="javascript:ShowSearch();"></asp:TreeNode>
                        <asp:TreeNode Text="<i class='f-advsearch fat'></i>高级搜索" NavigateUrl="javascript:toQuery();"></asp:TreeNode>
                        <asp:TreeNode Text="<i class='f-refresh'></i>导入导出" NavigateUrl="javascript:showIo()"></asp:TreeNode>
                        <asp:TreeNode Text="<i class='f-unit'></i>设置组织机构级别称谓" NavigateUrl="javascript:ShowLevels();"></asp:TreeNode>
                        <asp:TreeNode Text="<i class='f-uset'></i>设置默认用户信息" NavigateUrl="reg.aspx?mode=init"></asp:TreeNode>
                        <asp:TreeNode Text="<i class='f-dl'></i>下载用户操作日志" NavigateUrl="javascript:toDownloadLogs()"></asp:TreeNode>
                        <asp:TreeNode Text="<i class='f-bumen'></i>角色管理" NavigateUrl="roles.aspx"></asp:TreeNode>
                        <asp:TreeNode Text="<i class='f-ask'></i>帮助" NavigateUrl="javascript:toShowHelp();"></asp:TreeNode>
                    </asp:TreeNode>
                </Nodes>
            </asp:TreeView>
        </ContentTemplate>
        </asp:UpdatePanel>
    </td><td id="tdObjs" class="vtop">
        <asp:UpdatePanel ID="upObjs" runat="server" OnPreRender="AttObjEvent" UpdateMode="conditional" RenderMode="Block">
            <ContentTemplate>
                <div runat="server" id="divLocation"></div>
                <div id="objsDiv" runat="server"></div>
            </ContentTemplate>
        </asp:UpdatePanel>
    </td></tr>
    </table>
    <div class="menu" id="menu_obj">
        <a href="#" onclick="return del();" class="delete">删除</a>
        <a href="#" onclick="return cut('User');" class="f-cut">剪切</a>
        <div></div>
        <a href="#" runat="server" onserverclick="ShowAttributes" id="showAttributes">属性</a>
    </div>
    <div class="menu" id="menu_unit">
        <a href="#" onclick="ShowUnit();" id="openUnit">打开</a>
        <a href="#" onclick="cut('Unit');" class="f-cut">剪切</a>
        <a href="#" onclick="return renameUnit()">重命名</a>
        <a href="#" runat="server" id="delUnit" onserverclick="DelUnit" class="delete" onclick="return delUnit();">删除</a>
    </div>
    <div class="menu" id="menu_body">
        <a href="#" onclick="return cut('Users');" class="f-cut onselect">剪切选中用户</a>
        <a href="#" onclick="return delUsers();" class="delete onselect">删除选中用户</a>
        <div class="onselect"></div>
        <a href="#" onclick="return createUser();" class="f-adduser">添加用户</a>
        <a href="#" onclick="return createUnit();">添加机构</a>
        <a href="#" id="paste" runat="server" onserverclick="Paste">粘贴</a>
        <div></div>
        <a runat="server" id="aRole" href="roles.aspx" class="f-bumen">角色管理</a>
    </div>    
    <ims:Pop runat="server" ID="attr" Width="480" ShowOkButton="false" ShowCancelButton="false">
    <ContentTemplate>
        <fieldset runat="server" id="rolesArea"><legend>角色</legend>
            <div id="divRoles">
            <asp:CheckBoxList ID="roles" runat="server" RepeatLayout="Table" RepeatColumns="2" RepeatDirection="Horizontal"></asp:CheckBoxList>
            </div>
        </fieldset>
        <asp:HyperLink runat="server" Visible="false" ID="rolesAdmin" NavigateUrl="roles.aspx" Text="系统中尚未定义角色！点此新建角色 &gt;&gt;"></asp:HyperLink>
        <div class="mtop_n notfocus" id="ulAttrs">
        <ul>
            <li runat="server" id="divRelaName">真实姓名： <asp:TextBox runat="server" ID="tbRealName"></asp:TextBox></li>
            <li>所在机构： <asp:HyperLink runat="server" ID="hlUnit"></asp:HyperLink></li>
            <li>是否机构负责人： <asp:CheckBox runat="server" ID="cbRector" Text="是" /></li>
            <li id="managed" runat="server">分管的下级机构： <asp:CheckBoxList runat="server" ID="cblUnits" RepeatLayout="Flow" RepeatDirection="Horizontal"></asp:CheckBoxList></li>
            <li>兼任以下机构负责人： <asp:TextBox runat="server" ID="tbAnnex" acfid="UnitNameWithID" chars=";；、,，" ondblclick="showUserTree(this.id,true);" ToolTip="双击弹出机构选择窗口。多项之间以逗号、分号或顿号分隔。"></asp:TextBox>
            </li>
            <li runat="server" id="liAttr1"><span runat="server" id="attr1"></span>： <asp:TextBox runat="server" ID="tbAttr1"></asp:TextBox></li>
            <li runat="server" id="liAttr2"><span runat="server" id="attr2"></span>： <asp:TextBox runat="server" ID="tbAttr2"></asp:TextBox></li>
            <li runat="server" id="liAttr3"><span runat="server" id="attr3"></span>： <asp:TextBox runat="server" ID="tbAttr3"></asp:TextBox></li>
            <li runat="server" id="liSex">性别： <asp:RadioButtonList runat="server" ID="rblSex" RepeatDirection="Horizontal" RepeatLayout="Flow"><asp:ListItem Value="男" Selected="True">男</asp:ListItem><asp:ListItem Value="女">女</asp:ListItem></asp:RadioButtonList></li>
            <li runat="server" id="liWx">微信： <asp:TextBox runat="server" ID="tbWx"></asp:TextBox><i title="说明" onclick="ShowMsgPop('指企业微信通讯录中的用户帐号，不是微信号。建议在企业微信中将二者设为一致。', 90000, 'what');" class="what"></i></li>
            <li runat="server" id="liMail">邮箱： <asp:TextBox runat="server" ID="tbMail"></asp:TextBox></li>
            <li runat="server" id="liPhone">电话： <asp:TextBox runat="server" ID="tbPhone"></asp:TextBox></li>
            <li runat="server" id="liAddr">地址： <asp:TextBox runat="server" ID="tbAddr"></asp:TextBox></li>
            <li runat="server" id="liZip">邮编： <asp:TextBox runat="server" ID="tbZip"></asp:TextBox></li>
            <li runat="server" id="liLastLogin"></li>
        </ul>
        </div>
        <div class="footBtnArea">
            <asp:Button runat="server" ID="btnSave" OnClick="saveAttributes" Text="确定" CssClass="btn" />
            <asp:Button runat="server" ID="btnResetPwd" OnClick="ResetPass" Text="重置密码" OnClientClick="return confirm('确定要为该用户重置密码吗？');" CssClass="btn" />
            <asp:Button runat="server" ID="btnUnlock" OnClick="UnlockUser" Text="解除锁定" CssClass="btn" />
            <input type="button" onclick="user($('#curUserName').val());" value="通知" class="btn" />
            <input type="button" onclick="HideDialog(this);" value="取消" class="btn" />
        </div>
    </ContentTemplate>
    </ims:Pop>    
    <ims:Pop runat="server" ID="popSearch" Title="搜索用户" OkButtonText="搜索" OnOkClientClick="return searchUser();">
    <ContentTemplate>
        <br />
        <asp:DropDownList runat="server" ID="ddlNameType" onchange="$('#keyword').attr('acfid', $(this).val());"><asp:ListItem Selected="True" Value="UserIdenName">用户名</asp:ListItem><asp:ListItem Value="UserRealName">用户实名</asp:ListItem></asp:DropDownList> 包含：<input type="text" id="keyword" acfid="UserIdenName" onkeydown="return enterTo(event,'popSearch_btnOK');" style="width:175px" />
    </ContentTemplate>
    </ims:Pop> 
    <ims:Pop runat="server" ID="au" Title="高级搜索" Width="555" OkButtonText="搜索" OnOkClick="FindUsers">
        <ContentTemplate>
            <fieldset><legend><asp:RadioButtonList runat="server" ID="rblMode" RepeatLayout="Flow" RepeatDirection="Horizontal" ValidationGroup="mode"><asp:ListItem Value="1" Selected="True">以下用户</asp:ListItem><asp:ListItem Value="4">所有用户中排除以下用户</asp:ListItem></asp:RadioButtonList></legend>
                <div class="padbox notfocus">
                    <input type="checkbox" runat="server" id="cbUser" /><label for="au_cbUser">用户：</label><asp:TextBox runat="server" id="tbUsers" acfid="UserName" chars=";；、,，" ondblclick="showUserTree(this.id);" ToolTip="双击弹出用户选择窗口。多项之间以逗号、分号或顿号分隔" /><br />
                    <input type="checkbox" runat="server" id="cbRole" /><label for="au_cbRole">角色：</label><asp:TextBox runat="server" id="tbRoles" acfid="RoleName" chars=";；、,，" ToolTip="多项之间以逗号、分号或顿号分隔" /><br />
                    <input type="checkbox" runat="server" id="cbUnit" /><label for="au_cbUnit">机构：</label><asp:TextBox runat="server" id="tbUnits" acfid="UnitNameWithID" chars=";；、,，" ondblclick="showUserTree(this.id,true);" ToolTip="双击弹出机构选择窗口。多项之间以逗号、分号或顿号分隔" />
                    <span id="spanUnits"><input type="checkbox" class="hide" /><input runat="server" type="checkbox" id="cb_Rector" value="1" checked="checked" /><label for="au_cb_Rector">负责人</label><input runat="server" type="checkbox" id="cbDirectly" value="2" /><label for="au_cbDirectly">直属成员</label><input runat="server" type="checkbox" id="cbIndirect" value="4" /><label for="au_cbIndirect">非直属成员</label></span>
                    <div id="related">
                        <input type="checkbox" runat="server" id="cbRel" /><asp:TextBox runat="server" ID="tbBase" Width="90" ToolTip="输入用户名" placeholder="用户" acfid="UserName" ondblclick="showUserTree(this.id);"></asp:TextBox> 的： <span id="spanRel"><span><input class="hide" type="checkbox" /></span><input runat="server" type="checkbox" id="cbLateral" value="2" /><label for="au_cbLateral">平级</label> <input runat="server" type="checkbox" id="cbSuperior" value="4" /><label for="au_cbSuperior">上级</label><input runat="server" type="checkbox" id="cbDirectUnderling" value="8" /><label for="au_cbDirectUnderling">直接下级</label><input runat="server" type="checkbox" id="cbUnderling" value="16" /><label for="au_cbUnderling">所有下级</label><i title="相关说明" onclick="What('Colleague')" class="what hide1"></i></span>
                        <div runat="server" id="spanLevels"><span class="hidden"><input type="checkbox" /><input type="text" style="width:90px" /> 的： </span><input runat="server" type="checkbox" id="cbLevel" value="32" /><asp:DropDownList runat="server" ID="ddlLevels"></asp:DropDownList><span class="subItems">的： <input runat="server" type="checkbox" id="cbLevelRector" value="1" checked="checked" class="levelMember" /><label for="au_cbLevelRector">负责人</label><input runat="server" type="checkbox" class="levelMember" id="cbLevelDirectly" value="2" /><label for="au_cbLevelDirectly">直属成员</label><input runat="server" type="checkbox" class="levelMember" id="cbLevelIndirect" value="4" /><label for="cbLevelIndirect">非直属成员</label></span></div>
                    </div>
                </div>
            </fieldset>
        </ContentTemplate>
    </ims:Pop>   
    <ims:Pop runat="server" ID="lev" Title="设置组织机构级别称谓" OkButtonText="确定" OnOkClick="SaveLevels" Width="420">
    <ContentTemplate>
        <asp:TextBox runat="server" ID="tbLevels" Width="98%"></asp:TextBox>
        <div class="msgarea mtop_m">
            设置组织机构纵向各级别的称谓，有助于直观地定位各个层次。请按从顶至底的顺序填写，确保与机构设置相匹配，以逗号或顿号分隔，如：集团、公司、子公司、部门、科室、小组。
        </div>
    </ContentTemplate>
    </ims:Pop>
    <ims:Pop runat="server" ID="io" ShowOkButton="false" ShowCancelButton="false" Title="用户导入导出" Width="410">
        <ContentTemplate>
            <div class="center mtop_l">
                <label class="btn" title="从一个Excel文件中导入用户">导入用户<input id="xlsfile" name="xlsfile" type="file" onclick="return preImport();" onchange="return xlsUpload();" /><input runat="server" type="button" id="uploadXls" onserverclick="ShowUnit" class="hide" /></label>
                <asp:Button ID="btnToExcel" runat="server" class="btn" OnClick="ToExcel" ToolTip="将数据导出到一个Excel文件" Text="导出用户" />
                <asp:Button ID="excel" runat="server" class="btn" OnClick="MakeExcelTemplet" ToolTip="下载具有标题行的Excel空白表，便于整理用户数据供导入" Text="下载Excel表单" />
                <input type="button" class="btn pconly" value="帮助" onclick="showHelp('batchUser');" />
            </div>
        </ContentTemplate>
    </ims:Pop>
    <asp:UpdatePanel ID="upInfo" runat="server" UpdateMode="conditional" class="hide">
    <ContentTemplate>
        <asp:Button runat="server" ID="operaTrigger" OnClick="DoOpera" />
        <input type="button" runat="server" id="updateUsersCount" onserverclick="RefreshUsersCount" />
        <ul id="curInfo">
            <li>用户总数：<asp:Literal ID="usersCount" runat="server"></asp:Literal></li>
            <li runat="server" id="inRole"></li>
        </ul>
    </ContentTemplate>
    </asp:UpdatePanel>
    <script src="js/comm.js"></script><script src="js/users.js"></script>
    </form>
</body>
</html>