﻿<%@ page language="C#" autoeventwireup="true" inherits="ims.setup, ims.web" enableviewstatemac="false" enableEventValidation="false" %>
<!DOCTYPE html>
<html>
<head runat="server">
    <title>配置数据库</title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge" /><meta name="viewport" content="width=device-width,initial-scale=1">
    <style type="text/css">
        *{font-family:微软雅黑,Arial,宋体;margin:0;outline:none}
        a:link,a:visited{color:#1466E9;text-decoration:none}
        a:hover{color:#f52}
        table{width:100%;border-collapse:collapse}
        p{margin:2px 0}
        .right{text-align:right}
        .description{color:#9f9f9f;margin-left:5px;padding-left:6px;border-left:.8px #ccc solid}
        .red{color:#f52}
        .prompt{color:#9096a5;margin:14px 0 0;padding-top:3px;border-top:.9px #ccc dotted;line-height:1.6;display:none}
        #sqlserver td{padding-bottom:2px}
        #rbs{line-height:21px}
        #rbs *{vertical-align:middle;margin-right:4px}
        #up input{background:#009c9f;color:#fff;border:none;line-height:24px;padding:5px 15px;margin:0 8px}
        #up input:hover{background:#FFB800}
        .inputBox{width:200px;box-sizing:border-box}
    </style>
</head>
<body style="margin:19px 6%;font-size:12.35px;color:#333">
    <form id="form1" runat="server">
        <asp:ScriptManager ID="s1" AsyncPostBackTimeout="250" runat="server" OnAsyncPostBackError="AsyncError">
            <CompositeScript Path="js/msajax.js" ScriptMode="Release">
                <Scripts>
                    <asp:ScriptReference Name="WebForms.js" Assembly="System.Web" /><asp:ScriptReference Name="MicrosoftAjax.js" /><asp:ScriptReference Name="MicrosoftAjaxWebForms.js" />
                </Scripts>
            </CompositeScript>
        </asp:ScriptManager>
        <div id="mainArea">
        <div style="float:left;height:26px;line-height:26px;font-size:16px;font-weight:300;padding-bottom:2px">选择数据库</div>
        <div id="loading" style="float:right;background:url(images/loading_ov.gif) no-repeat 0 50%;padding-left:20px;height:22px;line-height:22px;display:none">请稍候…</div>
        <div style="border-top:.9px #d2d2d2 solid;padding:8px 0 12px;clear:both;">
            <div id="rbs">
                <asp:RadioButton GroupName="dbs" ID="rbAccess" Checked="true" Text="Access" runat="server" /><span class="description">系统内置的默认数据库，小巧方便</span><br />
                <asp:RadioButton GroupName="dbs" ID="rbSqlServer" Text="SQL Server" runat="server" /><span class="description">速度快，容量大，需单独安装</span>
            </div>
            <div id="sqlserver" style="display:none;">
            <div style="background:#f4f4f4;margin:8px 0 0 17px;padding:12px 12px 12px 15px;color:#222">
                <table>
                    <tr>
                        <td style="width:5.2em">服务器：</td>
                        <td>
                            <asp:UpdatePanel ID="upServers" runat="server" RenderMode="inline" UpdateMode="conditional">
                            <ContentTemplate>
                            <asp:TextBox ID="tbServer" runat="server" CssClass="inputBox"></asp:TextBox>
                                <asp:DropDownList runat="server" ID="ddlServers" Visible="false"></asp:DropDownList>&nbsp;
                                <asp:LinkButton ID="lbFind" runat="server" OnClick="BindServers">查找服务器</asp:LinkButton>
                            </ContentTemplate>
                            </asp:UpdatePanel>
                        </td>
                    </tr>
                    <tr><td>身份验证：</td><td><asp:DropDownList ID="ddlAuthmodes" CssClass="inputBox" runat="server"><asp:ListItem Value="windows" Selected="True">Windows 身份验证</asp:ListItem><asp:ListItem Value="sqlserver">SQL Server 身份验证</asp:ListItem></asp:DropDownList></td></tr>
                    <tr id="trName" style="display:none"><td class="right">用户名：</td><td><asp:TextBox ID="tbUserName" runat="server" CssClass="inputBox"></asp:TextBox></td></tr>
                    <tr id="trPass" style="display:none"><td class="right">密　码：</td><td><asp:TextBox ID="tbPassword" TextMode="Password" runat="server" CssClass="inputBox"></asp:TextBox></td></tr>
                </table>
                <div class="prompt">
                    <p>使用SQL Server，有两种方法：</p>
                    <p>1. <span runat="server" id="sqlTool">使用 <a href="https://landian.cc/download/SqlSetup.exe" target="_blank">SQL Server自动安装工具</a> 安装</span>，此处用 <span runat="server" id="authTxt">Windows身份验证</span>，服务器默认是"<span class="red">.\sqlexpress</span>"；</p>
                    <p>2. 安装 <a runat="server" id="sqlLink" target="_blank">SQL Server 2008 Express</a>，用 SQL Server Management Studio 连接，在左侧"安全性"上右键，新建 - 登录名，填入"<span class="red"><%= AspNetUser %></span>"，切换到"服务器角色"，全部勾选。此处用 Windows身份验证，服务器默认是"<span class="red">.\sqlexpress</span>"。</p>
                </div>
            </div>
            </div>
        </div>
        <div runat="server" id="msg" style="color:Red;margin-bottom:1em" visible="false"></div>
        <asp:UpdatePanel ID="up" runat="server" RenderMode="Block" UpdateMode="conditional" style="text-align:center;margin-top:48px">
        <ContentTemplate>
            <asp:Button ID="btnOk" runat="server" OnClick="btnOk_Clicked" Text="确定" />
            <asp:Button ID="btnBack" runat="server" OnClientClick="location='maint.aspx';" Text="返回" Visible="false" />
        </ContentTemplate>
        </asp:UpdatePanel>
        
        </div>
        <div style="display:none;text-align:center;margin:10em auto 4em" id="loading2"><img src="images/loading.gif" /></div>
   <script src="js/comm.js"></script>
   <script>
        function setSqlArea() {
            $('#sqlserver,.prompt').css("display", $f('rbSqlServer').checked ? 'block' : 'none');
        }
        function setSqlNamePass() {
            var e = $f("ddlAuthmodes");
            $f('trName').style.display = $f('trPass').style.display = e.options[e.selectedIndex].value == 'sqlserver' ? '' : 'none';
        }
        function setSqlServer(e) {
            var value = e.options[e.selectedIndex].value;
            if (value != "") $f("tbServer").value = value;
        }
        window.onload = function () {
            try {
                setSqlArea();
                setSqlNamePass();
                var prm = Sys.WebForms.PageRequestManager.getInstance();
                prm.add_initializeRequest(function () {
                    $f("loading").style.display = "block";
                    $("#up :submit").prop("disabled", true);
                });
                prm.add_endRequest(function () {
                    $f("loading").style.display = "none";
                    $("#up :submit").prop("disabled", false);
                });
            } catch (e) { }
        }
        function toRedirect() {
            $f('mainArea').style.display = 'none';
            $f('loading2').style.display = 'block';
            parent.location = "login.aspx";
        }
       //覆盖自定义alert函数，因本页面没有相应CSS
        function alert(msg) {
            winalert(msg);
        }
    </script>
    </form>
</body>
</html>