﻿<%@ page language="C#" autoeventwireup="true" inherits="ims.search, ims.web" enableviewstatemac="false" enableEventValidation="false" %>
<!DOCTYPE html>
<html id="search">
<head runat="server">
    <title></title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge" /><meta name="viewport" content="width=device-width,initial-scale=1">
</head>
<body>
    <form id="form1" runat="server">
        <asp:ScriptManager ID="s1" runat="server" OnAsyncPostBackError="AsyncError">
            <CompositeScript Path="js/msajax.js" ScriptMode="Release">
                <Scripts>
                    <asp:ScriptReference Name="WebForms.js" Assembly="System.Web" /><asp:ScriptReference Name="MicrosoftAjax.js" /><asp:ScriptReference Name="MicrosoftAjaxWebForms.js" />
                </Scripts>
            </CompositeScript>
        </asp:ScriptManager>
        <div runat="server" id="pageTitle" class="leftTitle"></div>
        <asp:UpdatePanel runat="server" ID="box" class="middle smallbtns hidden" ChildrenAsTriggers="false" OnPreRender="UpPreRender" UpdateMode="Conditional">
            <ContentTemplate>
                <asp:DropDownList runat="server" ID="ddlts" AutoPostBack="true" OnSelectedIndexChanged="TempletChanged" ToolTip="选择数据"></asp:DropDownList>
                <asp:DropDownList runat="server" ID="ddlViews" onchange="viewChanged();">
                    <asp:ListItem Selected="False" Value="Chart">图表</asp:ListItem>
                    <asp:ListItem Value="Report">报表</asp:ListItem>
                    <asp:ListItem Value="Table">表格视图</asp:ListItem>
                    <asp:ListItem Value="Overview">概要视图</asp:ListItem>
                    <asp:ListItem Value="Thumbnail">缩略视图</asp:ListItem>
                    <asp:ListItem Value="Detail">详情视图</asp:ListItem>
                </asp:DropDownList>
                <asp:DropDownList runat="server" ID="ddlCharts" ToolTip="选择图表"></asp:DropDownList>
                <asp:DropDownList runat="server" ID="ddlReports" ToolTip="选择报表"></asp:DropDownList>
                <asp:DropDownList runat="server" ID="ddlFilter" AutoPostBack="true" OnSelectedIndexChanged="FilterChanged" onchange="return finderChanged();" ToolTip="选择过滤器或搜索版式"></asp:DropDownList>
                &nbsp;<div id="searcher" runat="server"></div><button runat="server" id="btnDo" onserverclick="Exec" class="btn small rd">查询</button>
            </ContentTemplate>
            <Triggers>
                <asp:AsyncPostBackTrigger ControlID="ddlts" EventName="SelectedIndexChanged" />
                <asp:AsyncPostBackTrigger ControlID="ddlFilter" EventName="SelectedIndexChanged" />
            </Triggers>
        </asp:UpdatePanel>
        <asp:UpdatePanel runat="server" ID="res" ChildrenAsTriggers="false"  UpdateMode="Conditional">
            <ContentTemplate>
                <div runat="server" id="result"></div>
                <div class="footBtnArea" id="btnArea">
                    <input type="button" runat="server" id="btnExport" onclick="return toExportAs('#result');" value="导出" class="btn" visible="false" />
	                <input type="button" runat="server" id="btnPrint" class="btn pconly" onclick="$('#result').printIt({ event: event });" value="打印" visible="false" />
	                <input type="button" runat="server" id="btnLink" class="btn pconly" onclick="ShowPop('link_popup');makeLink();" value="生成链接" />
                    <input type="button" onclick="toAdvSearch();" value="高级搜索" class="btn" />
                    <input type="button" onclick="back();" value="返回" class="btn" />
                </div>
            </ContentTemplate>
        </asp:UpdatePanel>
        <ims:Pop runat="server" ID="link" Width="440" ShowOkButton="false" CanelButtonText="关闭">
            <ContentTemplate>
                <fieldset><legend>链接参数</legend>
                    <div class="padbox" style="line-height:1.7">
                        <input type="checkbox" id="cbTid" disabled checked /><label for="cbTid"></label>
                        <div class="middle">
                            <input type="checkbox" id="cbView" onclick="makeLink();" /><label for="cbView"></label><asp:DropDownList runat="server" ID="laysTable" onchange="$('#cbView').prop('checked',true);makeLink();"></asp:DropDownList><asp:DropDownList runat="server" ID="laysDetail" onchange="$('#cbView').prop('checked',true);makeLink();"></asp:DropDownList>
                        </div>
                        <div id="forStats">
                            <input type="checkbox" id="cbStats" onclick="makeLink();" /><label for="cbStats"></label>
                        </div>
                        <div id="forFinder">
                            <input type="checkbox" id="cbFinder" onclick="makeLink();" /><label for="cbFinder"></label>
                        </div>
                        <div id="forDo">
                            <input type="checkbox" id="cbDo" onclick="makeLink();" /><label for="cbDo">打开时显示结果</label>
                        </div>
                        <div id="forCache">
                            <input type="checkbox" id="cbCache" onclick="makeLink();" /><label for="cbCache">禁止缓存</label>
                        </div>
                    </div>
                </fieldset>
                <div class="mtop_s mbottom_l note">勾选的项将不显示；未勾选的由用户在操作时指定。</div>
                <fieldset><legend>链接地址</legend>
                    <div class="padbox">
                        <a class="green pointer mtop_m wrap" id="linkTxt" title="点击复制" onclick="toCopy(this)"></a>
                        <div class="mtop_s right">
                            <a href="#" id="aCopy" onclick="toCopy(this)">复制</a>&nbsp;
                            <a href="#" id="preview" onclick="return toPopup(this.href);">预览</a>
                        </div>
                    </div>
                </fieldset>
            </ContentTemplate>
        </ims:Pop>
        <script src="js/comm.js"></script><script src="js/echart.js"></script><script src="js/datepicker/WdatePicker.js"></script><script src="js/search.js"></script>
    </form>
</body>
</html>
