﻿<%@ page language="C#" autoeventwireup="true" inherits="ims.admin, ims.web" enableviewstatemac="false" enableEventValidation="false" %>
<!DOCTYPE html>
<html id="admin">
<head runat="server">
    <title>系统设置</title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width,initial-scale=1">
</head>
<body>
    <form id="form1" runat="server">
    <div class="hide"><input type="password" /></div>
        <asp:ScriptManager ID="s1" runat="server" EnablePageMethods="true" OnAsyncPostBackError="AsyncError">
            <CompositeScript Path="js/msajax.js" ScriptMode="Release">
                <Scripts>
                    <asp:ScriptReference Name="WebForms.js" Assembly="System.Web" /><asp:ScriptReference Name="MicrosoftAjax.js" /><asp:ScriptReference Name="MicrosoftAjaxWebForms.js" />
                </Scripts>
            </CompositeScript>
        </asp:ScriptManager>
        <div id="tabs" class="ui-tabs nobg noborder">
            <ul>
                <li><a href="#normal">常规</a></li>
                <li><a href="#funcs">功能</a></li>
                <li><a href="#userinfos">用户信息</a></li>
                <li><a href="#mail">邮件发送设置</a></li>
            </ul>
            <div id="normal">
                <div class="bhead mtop_m"><span>系统</span></div>
                <ul id="sysli">
                    <li title="本公司或单位的全称或简称">单位简称： <asp:TextBox runat="server" ID="orgName" MaxLength="255" Width="194"></asp:TextBox></li>
                    <li title="本软件系统的自定义名称">系统名称： <asp:TextBox runat="server" ID="sysName" MaxLength="255" Width="194"></asp:TextBox></li>
                    <li>数据中心自定义名称： <asp:TextBox runat="server" ID="dataCenter" Width="131"></asp:TextBox></li>
                    <li>根目录的自定义名称： <asp:TextBox runat="server" ID="rootDir" Width="131"></asp:TextBox></li>
                    <li title="从互联网访问本系统所使用的网址。以/结尾，如 http://mysite.com/">系统互联网访问地址： <asp:TextBox runat="server" ID="tbInternetUrl" Width="212" ToolTip="从外网访问所用地址。若外网不能访问，请留空"></asp:TextBox></li>
                    <li class="pconly"><a href="login.aspx?mode=edit" target="_blank">自定义登录页面</a></li>
                    <li class="pconly"><a href="#" id="aIcons" runat="server" onserverclick="ShowIcons">自定义顶部导航栏</a></li>
                    <li>左侧栏风格： <asp:DropDownList runat="server" ID="ddlBg"><asp:ListItem Value="None" Selected="True">极简</asp:ListItem><asp:ListItem Value="Light">浅色</asp:ListItem><asp:ListItem Value="Dark">深色</asp:ListItem></asp:DropDownList></li>
                </ul>
                <div class="bhead mtop_l"><span>用户</span></div>
                <ul>
                    <li title="勾选以允许新用户自行注册"><asp:CheckBox runat="server" ID="UserReg" Text="允许用户注册"></asp:CheckBox></li>
                    <li title="设置当用户忘记密码时，是否允许找回密码（系统自动重置为新的随机密码并通知用户）">
                        <asp:CheckBox runat="server" ID="cbEnPwdRecovery" Text="允许找回密码" onclick="setPwdRecovery();"></asp:CheckBox>
                        <div id="prMailTemplet">
                            <a href="#" id="aPwdFind" class="vmiddle">找回密码邮件模板</a><br />
                            <div id="prTemplet" style="display:none"><asp:TextBox ID="ckPrMailTemplet" runat="server" TextMode="MultiLine"></asp:TextBox></div>
                        </div>
                    </li>
                    <li title="设置是否允许同一帐户在不同地方重复登录"><asp:CheckBox runat="server" ID="cbRepeatlogin" Text="允许重复登录" /></li>
                    <li title="设置是否必须登录后才能访问系统"><asp:CheckBox runat="server" ID="cbEnAnons" Text="允许匿名访问"></asp:CheckBox><i title="说明" onclick="What('anonyUser')" class="what"></i></li>
                    <li><asp:CheckBox runat="server" ID="cbLog" Text="记录操作日志" /></li>
                    <li title="设置新注册的用户或管理员直接添加的用户所属的默认角色">新用户默认角色： <asp:DropDownList ID="ddlRoles" runat="server"></asp:DropDownList></li>
                </ul>
                <div class="bhead mtop_l"><span>信息中心</span></div>
                <ul>
                    <li>信息中心名称： <asp:TextBox runat="server" ID="infoCenter" Width="134"></asp:TextBox></li>
                    <li>信息类型： <asp:DropDownList runat="server" ID="ddlInfoType">
                        <asp:ListItem Value="信息">信息</asp:ListItem>
                        <asp:ListItem Value="通知/公告">通知/公告</asp:ListItem>
                        <asp:ListItem Value="文档">文档</asp:ListItem>
                        <asp:ListItem Value="新闻">新闻</asp:ListItem>
                        <asp:ListItem Value="工作日志">工作日志</asp:ListItem>
                        <asp:ListItem Value="帖子">帖子</asp:ListItem>
                    </asp:DropDownList></li>
                    <li><span class="vmiddle">需要审核： </span><asp:CheckBoxList runat="server" ID="cblAuditRange" RepeatLayout="Flow" RepeatDirection="Horizontal"><asp:ListItem Value="Article">文章</asp:ListItem><asp:ListItem Value="Comment">评论</asp:ListItem></asp:CheckBoxList>，
                        <span class="vmiddle">通知审核：</span><asp:CheckBoxList runat="server" ID="cblAudit" RepeatLayout="Flow" RepeatDirection="Horizontal">
                            <asp:ListItem Value="4">消息</asp:ListItem>
                            <asp:ListItem Value="1">邮件</asp:ListItem>
                            <asp:ListItem Value="2">短信</asp:ListItem>
                            <asp:ListItem Value="8">微信</asp:ListItem>
                        </asp:CheckBoxList><i title="说明" onclick="What('infoAudit')" class="what"></i>
                    </li>
                    <li>栏目： <asp:TextBox runat="server" ID="tbTypes" ToolTip="输入各个栏目名称，以逗号分隔。&#13;子栏目以“/”分隔，如：通知/会议纪要"></asp:TextBox></li>
                    <li><asp:CheckBox runat="server" ID="cbAdminCommentOwn" Text="允许编辑/删除自己发表的评论" /></li>
                    <li><asp:CheckBox runat="server" ID="cbAuthorDelComment" Text="允许信息发布者删除评论" /></li>
                </ul>
                <asp:UpdatePanel ID="forWorkflow" runat="server" UpdateMode="Conditional" RenderMode="Block">
                <ContentTemplate>
                    <div class="bhead mtop_l"><span>工作流</span></div>
                    <ul>
                        <li>事务中心名称： <asp:TextBox runat="server" ID="transCenter" Width="134"></asp:TextBox></li>
                        <li>允许用户查看以下人员的事务： <asp:CheckBoxList runat="server" ID="cblViewTask" RepeatLayout="Flow" RepeatDirection="Horizontal">
                                <asp:ListItem Value="8">直接下级</asp:ListItem>
                                <asp:ListItem Value="16">所有下级</asp:ListItem>
                                <asp:ListItem Value="2">同一机构的平级人员</asp:ListItem>
                                <asp:ListItem Value="4">直接上级</asp:ListItem>
                                <asp:ListItem Value="64">所有人</asp:ListItem>
                            </asp:CheckBoxList></li>
                        <li><asp:CheckBox runat="server" ID="cbAsDirectly" Text="下一级机构的负责人作为本机构直属成员" /></li>
                        <li><a href="###" id="aWorkday" runat="server" onserverclick="ShowAdjust">工作日设置</a></li>
                    </ul>
                </ContentTemplate>
                    <Triggers>
                        <asp:AsyncPostBackTrigger ControlID="cbWf" EventName="CheckedChanged" />
                    </Triggers>
                </asp:UpdatePanel>
                <div class="bhead mtop_l"><span>其它</span></div>
                <ul>
                    <li title="设置是否对所有用户禁用右下角弹出帮助"><asp:CheckBox runat="server" ID="cbDisPophelp" Text="禁止自动弹出操作指导" onclick="promptPophelp(this);" /></li>
                    <li><asp:CheckBox runat="server" ID="cbFileLimit" Text="限制上传文件大小："></asp:CheckBox><asp:TextBox ID="tbFileLimit" runat="server" Width="45"></asp:TextBox> KB</li>
                    <li title="限制上传的图片尺寸，宽度或高度超过该数值时自动缩小"><asp:CheckBox runat="server" ID="cbPhotoLimit" Text="限制上传图片宽/高不超过："></asp:CheckBox><asp:TextBox
                            ID="tbPhotoLimit" runat="server" Width="45"></asp:TextBox> 像素</li>
                    <li><asp:CheckBox runat="server" ID="cbOriginal" Text="缩略图加载原图以提高清晰度" /></li>
                    <li><asp:CheckBox runat="server" ID="cbPopLink" Text="以弹出框打开字段链接" /></li>
                    <li class="middle"><span title="为启用了编辑器的字段选择编辑器的工作模式">在线编辑器模式： <asp:RadioButtonList ID="editorMode" runat="server" RepeatDirection="Horizontal" RepeatLayout="flow">
                        <asp:ListItem Value="Compact">精简</asp:ListItem>
                        <asp:ListItem Value="Normal">常规</asp:ListItem>
                        <asp:ListItem Value="Advanced">高级</asp:ListItem>
                        </asp:RadioButtonList></span>， <asp:CheckBox runat="server" ID="cbViewable" Text="插入图片/链接时，允许浏览现有文件" />
                    </li>
                    <li><a href="#" onclick="return ShowPop('ext_popup');">允许上传的文件类型</a></li>
                    <li><a href="#" runat="server" id="adp" onserverclick="DesignProtcted">模板保护设置</a></li>
                    <li>
                        <a href="javascript:void(0);" onclick="$('#myHelp').slideToggle('fast');" title="自定义帮助中“系统说明”的内容">自定义系统帮助</a><br />
                        <div id="myHelp" style="display:none"><asp:TextBox ID="tbHelp" runat="server" TextMode="MultiLine"></asp:TextBox></div>
                    </li>
                    <li><a href="#" onclick="return showHelp('moreSetting');">更多设置</a></li>
                </ul>
            </div>
            <div id="funcs">
                <div>
                    <ul>
                        <li title="确定是否开启工作流，以实现诸如审批之类的流程性功能"><asp:CheckBox runat="server" ID="cbWf" Text="工作流功能" OnCheckedChanged="cbWfChanged" AutoPostBack="true"></asp:CheckBox></li>
                        <li title="勾选后，将可以控制用户的目录操作权限（创建、删除等）"><asp:CheckBox runat="server" ID="cbEnDirPower" Text="目录权限控制"></asp:CheckBox></li>
                        <li title="勾选以启用电子商务功能，从而允许用户选购商品并提交订单">
                        <asp:CheckBox runat="server" ID="eShop" Text="电子商务功能" onclick="setEshoplink(true);"></asp:CheckBox>
                            <asp:HyperLink ID="toEShopSetting" NavigateUrl="~/eshopsetting.aspx" runat="server" onclick="return toPopup(this.href,950,640);">设置</asp:HyperLink>
                        </li>
                    </ul>
                </div>
                <div>
                    <ul>
                        <li><asp:CheckBox runat="server" ID="sms" Text="短信发送" onclick="setSmslink();"></asp:CheckBox>
                            <asp:HyperLink runat="server" ID="hlsms" Text="设置" NavigateUrl="smsadmin.aspx" onclick="return toPopup(this.href,560,420);"></asp:HyperLink>
                        </li>
                        <li><asp:CheckBox runat="server" ID="cbHotline" Text="来电弹屏" onclick="setHotlineLink();"></asp:CheckBox>
                            <asp:HyperLink ID="hlHotline" NavigateUrl="hotline.aspx" runat="server" onclick="return toPopup(this.href,690,420);">设置</asp:HyperLink>
                        </li>
                        <li><asp:CheckBox runat="server" ID="cbWeixin" Text="微信功能" onclick="setWeixinLink();"></asp:CheckBox>
                            <asp:HyperLink ID="hlWeixin" NavigateUrl="wxadmin.aspx" runat="server" onclick="return toPopup(this.href,650,480);">设置</asp:HyperLink>
                        </li>
                    </ul>
                </div>
                <div>
                    <ul>
                        <li><asp:CheckBox runat="server" ID="cbMsg" Text="消息功能"></asp:CheckBox></li>
                        <li><asp:CheckBox runat="server" ID="cbFavorites" Text="收藏功能"></asp:CheckBox></li>
                        <li><asp:CheckBox runat="server" ID="cbApi" Text="API接口" onclick="setApiLink();"></asp:CheckBox>
                            <a id="aApi" runat="server" onserverclick="ShowApi">设置</a>
                        </li>
                    </ul>
                </div>
            </div>
            <asp:UpdatePanel ID="userinfos" runat="server" ChildrenAsTriggers="true" UpdateMode="Conditional" RenderMode="Block">
            <ContentTemplate>
                <div id="uiTitle"><i class="infoico"></i>请勾选要启用的字段：</div>
                <ul class="ulList">
                    <li><asp:CheckBox AutoPostBack="true" OnCheckedChanged="cbChanged" runat="server" ID="cbEmail" Text="邮箱：" /><asp:CheckBox runat="server" ID="cbEmail_r" Text="必填" /></li>
                    <li><asp:CheckBox AutoPostBack="true" OnCheckedChanged="cbChanged" runat="server" ID="cbPhone" Text="电话：" /><asp:CheckBox runat="server" ID="cbPhone_r" Text="必填" /></li>
                    <li><asp:CheckBox AutoPostBack="true" OnCheckedChanged="cbChanged" runat="server" ID="cbAddress" Text="地址：" /><asp:CheckBox runat="server" ID="cbAddress_r" Text="必填" /></li>
                    <li><asp:CheckBox AutoPostBack="true" OnCheckedChanged="cbChanged" runat="server" ID="cbZip" Text="邮编：" /><asp:CheckBox runat="server" ID="cbZip_r" Text="必填" /></li>
                    <li><asp:CheckBox AutoPostBack="true" OnCheckedChanged="cbChanged" runat="server" ID="cbSex" Text="性别：" /><asp:CheckBox runat="server" ID="cbSex_r" Text="必填" /></li>
                    <li><asp:CheckBox runat="server" ID="cbPasswordQuestion" Text="密码问题：" /><asp:CheckBox runat="server" ID="cbPasswordQuestion_r" Checked="true" Enabled="false" Text="必填" /></li>
                    <li><asp:CheckBox runat="server" ID="cbPasswordAnswer" Text="密码答案：" /><asp:CheckBox runat="server" ID="cbPasswordAnswer_r" Checked="true" Enabled="false" Text="必填" /></li>
                    <li><asp:CheckBox AutoPostBack="true" OnCheckedChanged="cbChanged" runat="server" ID="cbWxAccount" Text="微信帐号：" /><asp:CheckBox runat="server" ID="cbWxAccount_r" Text="必填" /></li>
                    <li><asp:CheckBox AutoPostBack="true" OnCheckedChanged="cbChanged" runat="server" ID="cbRealName" Text="真实姓名：" /><asp:CheckBox runat="server" ID="cbRealName_r" Text="必填" /> <asp:CheckBox runat="server" ID="cbEnChange" Text="允许自行修改" /></li>
                </ul>
                <div class="lightarea" id="attrpmt"><i class="f-idea fat yellow"></i>可添加自定义属性，用户这些属性由管理员设置，可在条件或版式中以变量表达</div>
                <ul class="ulList">
                    <li>属性1：<asp:TextBox runat="server" ID="tbAttr1" title="输入属性名"></asp:TextBox></li>
                    <li>属性2：<asp:TextBox runat="server" ID="tbAttr2" title="输入属性名"></asp:TextBox></li>
                    <li>属性3：<asp:TextBox runat="server" ID="tbAttr3" title="输入属性名"></asp:TextBox></li>
                </ul>
            </ContentTemplate>
            </asp:UpdatePanel>
            <asp:UpdatePanel ID="mail" runat="server" ChildrenAsTriggers="true" UpdateMode="Conditional" RenderMode="inline">
            <ContentTemplate>
                <ul>
                    <li>发件邮箱地址：<asp:TextBox ID="tbFromEamil" runat="server" Width="160"></asp:TextBox></li>
                    <li>发送者的名称：<asp:TextBox ID="tbDisplayName" runat="server" Width="160"></asp:TextBox></li>
                    <li>SMTP&nbsp;服务器：<asp:TextBox ID="tbSmtpHost" runat="server" Width="160"></asp:TextBox></li>
                    <li>SMTP&nbsp;端口号：<asp:TextBox ID="tbSmtpPort" Width="45" runat="server"></asp:TextBox></li>
                    <li><asp:CheckBox ID="cbSSL" Text="使用SSL安全连接" runat="server" /></li>
                    <li><asp:CheckBox ID="cbNeedAuth" AutoPostBack="true" OnCheckedChanged="cbNeedAuth_changed" Text="SMTP服务器需要身份验证" Checked="true" runat="server" /><span runat="server" id="authInfo">，帐号：<asp:TextBox ID="tbUserName" Width="100" runat="server"></asp:TextBox> 密码：<asp:TextBox ID="tbPassWord" Width="100" TextMode="Password" runat="server" autocomplete="new-password"></asp:TextBox></span><asp:Button runat="server" id="smtpTest" OnClick="SmtpTest" Text="测试" CssClass="btn sec small" />
                    </li>
                </ul>
            </ContentTemplate>
            </asp:UpdatePanel>
        </div>
        <asp:UpdatePanel ID="up4" runat="server" ChildrenAsTriggers="true" UpdateMode="Conditional" RenderMode="Block" class="footBtnArea">
        <ContentTemplate>
            <asp:Button ID="btnSave" runat="server" Text="保存设置" OnClientClick="UpdateEditorElement()" OnClick="saveOption" CssClass="btn" />
            <input type="button" value="帮助" onclick="showHelp();" class="btn pconly" />
        </ContentTemplate>
        </asp:UpdatePanel>
        <ims:Pop runat="server" ID="days" Width="500" Title="工作日设置" OnOkClick="SaveWorkDay">
            <ContentTemplate>
                <asp:DropDownList runat="server" ID="ddlWeekendAs"><asp:ListItem Value="false">默认周末为非工作日</asp:ListItem><asp:ListItem Value="true">默认周末为工作日</asp:ListItem></asp:DropDownList>，并作如下调整：<br />
                <table class="normal mtop_s">
                    <tr><th>调整主题</th><th>调整时段</th><th style="width:75px">调整为</th><th style="width:36px">操作</th></tr>
                    <asp:PlaceHolder runat="server" ID="phItems"></asp:PlaceHolder>
                    <tr><td><asp:TextBox runat="server" ID="tbSubject"></asp:TextBox></td><td><asp:TextBox runat="server" ID="tbStart" CssClass="tbdate" onfocus="WdatePicker({el:this,dateFmt:'yyyy-MM-dd',onpicked:function(){$('#days_tbEnd').focus();}});"></asp:TextBox>～<asp:TextBox runat="server" ID="tbEnd" CssClass="tbdate" onfocus="WdatePicker({el:this,dateFmt:'yyyy-MM-dd'});"></asp:TextBox></td><td><asp:DropDownList runat="server" ID="ddlDayType"><asp:ListItem Value="false">非工作日</asp:ListItem><asp:ListItem Value="true">工作日</asp:ListItem></asp:DropDownList></td><td><asp:LinkButton runat="server" ID="lbAdd" OnClick="AddAdjust" Text="添加"></asp:LinkButton></td></tr>
                </table>
                <asp:Button runat="server" ID="btnDelAdjust" OnClick="DelAdjust" CssClass="hide" />
            </ContentTemplate>
        </ims:Pop>
        <ims:Pop runat="server" ID="pp" Width="500" OnOkClick="SaveProtected" HideOnOkClientClick="false" OnOkClientClick="return confirmProtect();" HelpSubject="DesignProtect" OnClientUpdated="setStatus();" CustomCss="notfocus">
            <ContentTemplate>
                <fieldset><legend><asp:CheckBox runat="server" ID="cbProtect" onclick="setStatus();" Text="启用模板保护" /></legend>
                    <div class="padbox" id="ppMain">
                        密码：<asp:TextBox TextMode="Password" runat="server" ID="tbPwd"></asp:TextBox>，保护：
                        <div class="sepline2"></div>
                        <asp:CheckBoxList runat="server" ID="cblProtected" RepeatLayout="Flow" CssClass="green middle" RepeatDirection="Horizontal"></asp:CheckBoxList>
                        <div class="selecter"><button type="button" class="f-duoxuan btn smest outline" onclick="SelectAll(this,'pp_cblProtected');">全选</button><button type="button" class="f-ok btn smest outline" onclick="RevSelect('pp_cblProtected');">反选</button></div>
                    </div>
                </fieldset>
            </ContentTemplate>
        </ims:Pop>
        <ims:Pop runat="server" ID="myapi" Title="API设置" OnOkClick="SaveApi" Width="318" HelpSubject="api" HideOnOkClientClick="false">
            <ContentTemplate>
                <div class="mbottom_m">
                    Key：<br />
                    <asp:TextBox runat="server" ID="tbKey" Width="206px"></asp:TextBox><input type="button" class="btn sec small" value="随机生成" onclick="$('#myapi_tbKey').val(randomString(12));" />
                </div>
                允许以下域调用API<i title="说明" onclick="What('cors')" class="what"></i>：<br />
                <asp:TextBox runat="server" ID="tbDomains" Width="272px" ToolTip="留空表示不允许跨域调用；“*”允许任意域调用；多个域以逗号分隔"></asp:TextBox>
            </ContentTemplate>
        </ims:Pop>
        <ims:Pop runat="server" ID="ti" Title="添加顶栏自定义图标" Width="420px" OnOkClick="SaveIcons" OnClientUpdated="initIcons();" HideOnOkClientClick="false">
            <ContentTemplate>
                <table class="normal fixedLayout mbottom_s" id="tbs">
                    <tr><th style="width:4.2em">图标</th><th style="width:4.1em">颜色</th><th style="width:5.2em">文字</th><th>链接地址</th></tr>
                    <tr><td><asp:TextBox runat="server" ID="ico1"></asp:TextBox></td><td><asp:TextBox runat="server" ID="color1"></asp:TextBox></td><td><asp:TextBox runat="server" ID="txt1" MaxLength="5"></asp:TextBox></td><td><asp:TextBox runat="server" ID="url1"></asp:TextBox></td></tr>
                    <tr><td><asp:TextBox runat="server" ID="ico2"></asp:TextBox></td><td><asp:TextBox runat="server" ID="color2"></asp:TextBox></td><td><asp:TextBox runat="server" ID="txt2" MaxLength="5"></asp:TextBox></td><td><asp:TextBox runat="server" ID="url2"></asp:TextBox></td></tr>
                    <tr><td><asp:TextBox runat="server" ID="ico3"></asp:TextBox></td><td><asp:TextBox runat="server" ID="color3"></asp:TextBox></td><td><asp:TextBox runat="server" ID="txt3" MaxLength="5"></asp:TextBox></td><td><asp:TextBox runat="server" ID="url3"></asp:TextBox></td></tr>
                    <tr><td><asp:TextBox runat="server" ID="ico4"></asp:TextBox></td><td><asp:TextBox runat="server" ID="color4"></asp:TextBox></td><td><asp:TextBox runat="server" ID="txt4" MaxLength="5"></asp:TextBox></td><td><asp:TextBox runat="server" ID="url4"></asp:TextBox></td></tr>
                    <tr><td><asp:TextBox runat="server" ID="ico5"></asp:TextBox></td><td><asp:TextBox runat="server" ID="color5"></asp:TextBox></td><td><asp:TextBox runat="server" ID="txt5" MaxLength="5"></asp:TextBox></td><td><asp:TextBox runat="server" ID="url5"></asp:TextBox></td></tr>
                </table>
                <table>
                    <tr>
                        <td class="left"><asp:CheckBox runat="server" ID="cbBg" Text="启用背景图" /></td>
                        <td class="right"><label id="lLogo" class="pointer forFile" title="点击上传新图标">更换LOGO图标<input id="fileToUpload" type="file" name="fileToUpload" onchange="return uploadLogo();" /></label></td>
                    </tr>
                </table>
            </ContentTemplate>
        </ims:Pop>
        <ims:Pop runat="server" ID="ext" Title="允许上传的文件类型" Width="400" OnOkClick="SaveExts">
            <ContentTemplate>
                <div class="lightarea infoico">
                    填写允许上传的文件类型扩展名，以逗号分隔。
                </div>
                <asp:TextBox runat="server" ID="tbExts" TextMode="MultiLine"></asp:TextBox>
            </ContentTemplate>
        </ims:Pop>
    <script src="js/comm.js"></script><script src="js/admin.js"></script>
    </form>
</body>
</html>