/*
 * Decompiled with CFR 0.152.
 */
package com.jobjects.jst.win32;

import com.jobjects.jst.ServiceControlException;
import com.jobjects.jst.ServiceControlListener;
import com.jobjects.jst.ServiceControlManager;
import com.jobjects.jst.ServiceSettings;
import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class SCM
implements ServiceControlManager {
    private Vector listeners = new Vector();
    private boolean isNT;

    public SCM(boolean nt) {
        this.isNT = nt;
    }

    public synchronized void addServiceControlListener(ServiceControlListener lis) {
        this.listeners.insertElementAt(lis, 0);
    }

    public synchronized void removeServiceControlListener(ServiceControlListener lis) {
        this.listeners.removeElement(lis);
    }

    protected synchronized void notifyOnStop() {
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            ((ServiceControlListener)e.nextElement()).stopService();
        }
    }

    protected synchronized void notifyOnPause() {
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            ((ServiceControlListener)e.nextElement()).pauseService();
        }
    }

    protected synchronized void notifyOnContinue() {
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            ((ServiceControlListener)e.nextElement()).continueService();
        }
    }

    protected synchronized void notifyOnShutdown() {
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            ((ServiceControlListener)e.nextElement()).shutdownService();
        }
    }

    public void createService(ServiceSettings srvset) throws ServiceControlException {
        if (srvset.getClasspath() == null) {
            srvset.setClasspath(System.getProperty("java.class.path"));
        }
        if (this.isNT ? !this._createService(srvset) : !this._createService95(srvset)) {
            throw new ServiceControlException(this._getLastErrorDescription());
        }
    }

    public void deleteService(String name) throws ServiceControlException {
        if (name == null || name.length() == 0) {
            throw new IllegalAccessError();
        }
        if (this.isNT ? !this._deleteService(name) : !this._deleteService95(name)) {
            throw new ServiceControlException(this._getLastErrorDescription());
        }
    }

    protected static String lookupForFile(String name, int where) {
        String path = "";
        if ((where & 1) != 0) {
            path = String.valueOf(path).concat(String.valueOf(System.getProperty("java.class.path")));
        }
        if ((where & 2) != 0) {
            path = String.valueOf(path).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(File.pathSeparator).concat(String.valueOf("."))).concat(String.valueOf(File.pathSeparator))).concat(String.valueOf(SCM._getPathVariable()))));
        }
        StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            File lf;
            File f;
            String t = tok.nextToken().toLowerCase();
            if (t.equals(".")) {
                t = System.getProperty("user.dir");
            }
            if ((f = new File(t)).isFile() || t.endsWith(".zip") || t.endsWith(".jar")) {
                t = f.getParent();
                f = new File(t);
            }
            if ((lf = new File(f, name)).exists() && lf.isFile()) {
                return lf.getAbsolutePath();
            }
            lf = new File(new File(f, "..\\lib"), name);
            if (lf.exists() && lf.isFile()) {
                return lf.getAbsolutePath();
            }
            lf = new File(new File(f, "..\\bin"), name);
            if (!lf.exists() || !lf.isFile()) continue;
            return lf.getAbsolutePath();
        }
        return null;
    }

    private native boolean _createService(ServiceSettings var1);

    private native boolean _deleteService(String var1);

    private native String _getLastErrorDescription();

    private static native String _getPathVariable();

    private native boolean _createService95(ServiceSettings var1);

    private native boolean _deleteService95(String var1);

    static {
        String fullpath = SCM.lookupForFile("jst.dll", 1);
        if (fullpath != null) {
            System.load(fullpath);
        } else {
            System.loadLibrary("jst");
        }
    }
}

