/*
 * Decompiled with CFR 0.152.
 */
package com.borland.xml.toolkit.generator;

import com.borland.xml.toolkit.ErrorList;
import com.borland.xml.toolkit.InvalidDirectoryException;
import com.borland.xml.toolkit.InvalidParameterException;
import com.borland.xml.toolkit.XmlObject;
import com.borland.xml.toolkit.XmlUtil;
import com.borland.xml.toolkit.generator.BxPropertyHelper;
import com.borland.xml.toolkit.generator.ChildrenBlock;
import com.borland.xml.toolkit.generator.DTD2XML;
import com.borland.xml.toolkit.generator.DataModel;
import com.borland.xml.toolkit.generator.MarshalBlock;
import com.borland.xml.toolkit.generator.MetaClass;
import com.borland.xml.toolkit.generator.MetaElement;
import com.borland.xml.toolkit.generator.MetaEmpty;
import com.borland.xml.toolkit.generator.MetaInterface;
import com.borland.xml.toolkit.generator.MetaSimple;
import com.borland.xml.toolkit.generator.MetaText;
import com.borland.xml.toolkit.generator.MetaValue;
import com.borland.xml.toolkit.generator.MethodBlock;
import com.borland.xml.toolkit.generator.Operator;
import com.borland.xml.toolkit.generator.TemplateId;
import com.borland.xml.toolkit.generator.Translate;
import com.borland.xml.toolkit.generator.UnmarshalBlock;
import com.borland.xml.toolkit.generator.VariableBlock;
import com.borland.xml.toolkit.generator.model.Attribute;
import com.borland.xml.toolkit.generator.model.Child;
import com.borland.xml.toolkit.generator.model.Either;
import com.borland.xml.toolkit.generator.model.Empty;
import com.borland.xml.toolkit.generator.model.Left;
import com.borland.xml.toolkit.generator.model.ObjectModel;
import com.borland.xml.toolkit.generator.model.Right;
import com.borland.xml.toolkit.generator.model._Class;
import com.borland.xml.toolkit.generator.model._Interface;
import com.borland.xml.toolkit.generator.property.Adapter;
import com.borland.xml.toolkit.generator.property.BxProperty;
import com.borland.xml.toolkit.generator.property.ClassMappings;
import com.borland.xml.toolkit.generator.property.DomMappings;
import com.borland.xml.toolkit.generator.property.Dtd;
import com.borland.xml.toolkit.generator.property.Mapping;
import com.borland.xml.toolkit.generator.property.Model;
import com.borland.xml.toolkit.generator.property.More;
import com.borland.xml.toolkit.generator.property.ParserClass;
import com.borland.xml.toolkit.generator.property.Single;
import com.borland.xml.toolkit.generator.property.VariableNaming;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Generator
extends DataModel {
    private BxProperty bxPro = null;
    private static final String defaultSinglePrefix = "_obj";
    private static final String defaultSingleSuffix = "";
    private static final String defaultMorePrefix = "_obj";
    private static final String defaultMoreSuffix = "";
    private static final String defaultAttributePrefix = "";
    private static final String defaultAttributeSuffix = "";
    private static final String version = "1.2.0.B2.03";
    private static final String versionInfo = "Sep 21 2001";
    private Translate translate = new Translate();
    private TemplateId tid;
    private static ThreadLocal nameLocal = new ThreadLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };
    static /* synthetic */ Class class$com$borland$xml$toolkit$generator$Generator;

    public Generator() throws DataModel.MissingRootClassException {
    }

    public Generator(String string) throws InvalidDirectoryException, DataModel.MissingRootClassException {
        this();
        this.setTemplateDir(string);
    }

    public Generator(ObjectModel objectModel) throws DataModel.MissingRootClassException, InvalidParameterException {
        super(objectModel);
    }

    public Generator(ObjectModel objectModel, String string) throws InvalidDirectoryException, DataModel.MissingRootClassException, InvalidParameterException {
        this(objectModel);
        this.setTemplateDir(string);
    }

    protected void init(ObjectModel objectModel) throws DataModel.MissingRootClassException {
        super.init(objectModel);
    }

    public Generator(InputStream inputStream) throws DataModel.MissingRootClassException, InvalidParameterException {
        this(ObjectModel.unmarshal(inputStream));
    }

    public Generator(InputStream inputStream, String string) throws InvalidDirectoryException, DataModel.MissingRootClassException, InvalidParameterException {
        this(ObjectModel.unmarshal(inputStream), string);
    }

    public Generator(File file) throws InvalidDirectoryException, DataModel.MissingRootClassException, InvalidParameterException {
        this(ObjectModel.unmarshal(file));
        if (this.outputDir == null) {
            this.setOutputDir(file.getParent());
        }
    }

    public Generator(File file, String string) throws InvalidDirectoryException, DataModel.MissingRootClassException, InvalidParameterException {
        this(ObjectModel.unmarshal(file), string);
        if (this.outputDir == null) {
            this.setOutputDir(file.getParent());
        }
    }

    public Generator(String string, String string2) throws InvalidDirectoryException, DataModel.MissingRootClassException, InvalidParameterException {
        this(new File(string), string2);
    }

    public Generator(Reader reader) throws DataModel.MissingRootClassException, InvalidParameterException {
        this(ObjectModel.unmarshal(reader));
    }

    public Generator(Reader reader, String string) throws InvalidDirectoryException, DataModel.MissingRootClassException, InvalidParameterException {
        this(ObjectModel.unmarshal(reader), string);
    }

    public static ObjectModel getObjectModelFromDtd(String string, String string2) {
        return string == null || string.length() == 0 ? null : Generator.getObjectModelFromDtd(new File(string), string2);
    }

    public static ObjectModel getObjectModelFromDtd(File file, String string) {
        if (string == null || string.length() == 0 || file == null || file.getPath().length() == 0) {
            return null;
        }
        try {
            DTD2XML dTD2XML = new DTD2XML();
            dTD2XML.generate(file, string);
            return dTD2XML.getRoot();
        }
        catch (Exception exception) {
            System.out.println("Failed to process the DTD \"" + file.getName() + "\":" + exception.getMessage());
            return null;
        }
    }

    public static Generator importFromDtd(String string, String string2) throws DataModel.MissingRootClassException, InvalidDirectoryException {
        return string == null || string.length() == 0 ? null : Generator.importFromDtd(new File(string), string2);
    }

    public static Generator importFromDtd(String string, String string2, String string3) throws DataModel.MissingRootClassException, InvalidDirectoryException, GeneratorException {
        return string == null || string.length() == 0 ? null : Generator.importFromDtd(new File(string), string2, string3);
    }

    public static Generator importFromDtd(File file, String string) throws DataModel.MissingRootClassException, InvalidDirectoryException {
        Generator generator;
        ObjectModel objectModel = Generator.getObjectModelFromDtd(file, string);
        Generator generator2 = generator = objectModel != null ? new Generator(objectModel) : new Generator();
        if (generator.outputDir == null) {
            generator.setOutputDir(file.getParent());
        }
        return generator;
    }

    public static Generator importFromDtd(File file, String string, String string2) throws DataModel.MissingRootClassException, InvalidDirectoryException, GeneratorException {
        Generator generator;
        ObjectModel objectModel = Generator.getObjectModelFromDtd(file, string);
        Generator generator2 = generator = objectModel != null ? new Generator(objectModel, string2) : new Generator(string2);
        if (generator.outputDir == null) {
            generator.setOutputDir(file.getParent());
        }
        return generator;
    }

    public static Generator importFromBom(String string) throws DataModel.MissingRootClassException, InvalidDirectoryException {
        return Generator.importFromBom(new File(string));
    }

    public static Generator importFromBom(String string, String string2) throws DataModel.MissingRootClassException, InvalidDirectoryException, GeneratorException {
        return Generator.importFromBom(new File(string), string2);
    }

    public static Generator importFromBom(File file) throws DataModel.MissingRootClassException, InvalidDirectoryException {
        return Generator.isBomFile(file) ? new Generator(file) : null;
    }

    public static Generator importFromBom(File file, String string) throws DataModel.MissingRootClassException, InvalidDirectoryException, GeneratorException {
        return Generator.isBomFile(file) ? new Generator(file, string) : null;
    }

    public static Generator importModel(String string, String string2) throws DataModel.MissingRootClassException, InvalidDirectoryException {
        return Generator.importModel(new File(string), string2);
    }

    public static Generator importModel(String string, String string2, String string3) throws DataModel.MissingRootClassException, InvalidDirectoryException, GeneratorException {
        return Generator.importModel(new File(string), string2, string3);
    }

    public static Generator importModel(File file, String string) throws DataModel.MissingRootClassException, InvalidDirectoryException {
        if (Generator.isBomFile(file)) {
            return new Generator(file);
        }
        if (Generator.isDtdFile(file)) {
            return Generator.importFromDtd(file, string);
        }
        System.out.println("File must be *.dtd or *.bom");
        return null;
    }

    public static Generator importModel(File file, String string, String string2) throws DataModel.MissingRootClassException, InvalidDirectoryException, GeneratorException {
        if (Generator.isBomFile(file)) {
            return new Generator(file, string2);
        }
        if (Generator.isDtdFile(file)) {
            return Generator.importFromDtd(file, string, string2);
        }
        System.out.println("File must be *.dtd or *.bom");
        return null;
    }

    public void setTemplateDir(String string) throws InvalidDirectoryException {
        this.tid = TemplateId.getInstance();
        try {
            this.tid.loadTemplate(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void setTemplateResourcePath(Class clazz, String string) throws IOException {
        this.tid = TemplateId.getInstance();
        this.tid.loadTemplate(clazz != null ? clazz : (class$com$borland$xml$toolkit$generator$Generator == null ? (class$com$borland$xml$toolkit$generator$Generator = Generator.class$("com.borland.xml.toolkit.generator.Generator")) : class$com$borland$xml$toolkit$generator$Generator), string);
    }

    public TemplateId loadTemplate(String string) throws InvalidDirectoryException, IOException {
        if (this.tid == null) {
            this.tid = new TemplateId();
        }
        return this.tid.loadTemplate(string);
    }

    public TemplateId loadTemplate(Class clazz, String string) throws IOException {
        if (this.tid == null) {
            this.tid = new TemplateId();
        }
        return this.tid.loadTemplate(clazz != null ? clazz : (class$com$borland$xml$toolkit$generator$Generator == null ? (class$com$borland$xml$toolkit$generator$Generator = Generator.class$("com.borland.xml.toolkit.generator.Generator")) : class$com$borland$xml$toolkit$generator$Generator), string);
    }

    public void setTemplateId(TemplateId templateId) {
        this.tid = templateId;
    }

    public TemplateId getTemplateId() {
        return this.tid;
    }

    public ErrorList validate() {
        return this.getObjectModel().validate();
    }

    public List getMetaInterfaces() {
        ArrayList<MetaClass> arrayList = new ArrayList<MetaClass>();
        if (this.interfaces == null) {
            return arrayList;
        }
        int n = 0;
        while (n < this.interfaces.length) {
            try {
                MetaClass metaClass = this.generateInterface(this.interfaces[n]);
                if (metaClass != null) {
                    arrayList.add(metaClass);
                }
            }
            catch (GeneratorException generatorException) {
                generatorException.printStackTrace();
            }
            ++n;
        }
        return arrayList;
    }

    public List getMetaClasses() {
        ArrayList<MetaClass> arrayList = new ArrayList<MetaClass>();
        if (this.classes == null) {
            return arrayList;
        }
        int n = 0;
        while (n < this.classes.length) {
            try {
                MetaClass metaClass = this.generateClass(this.classes[n]);
                if (metaClass != null) {
                    arrayList.add(metaClass);
                }
            }
            catch (GeneratorException generatorException) {
                generatorException.printStackTrace();
            }
            ++n;
        }
        return arrayList;
    }

    public void generateCode(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.generateCode((MetaClass)iterator.next());
        }
    }

    public void generateCode(MetaClass metaClass) {
        File file = new File(this.outputDir, metaClass.getFileName());
        if (DataModel.makeDirs(this.outputDir, metaClass.getPackageName())) {
            metaClass.toString(file);
        } else {
            System.out.println("failed to create the directory for the package \"" + metaClass.getPackageName() + "\"");
        }
    }

    public void generateCode(_Class _Class2) throws GeneratorException {
        this.generateCode(this.generateClass(_Class2));
    }

    public String generateCodeString(_Class _Class2) throws GeneratorException {
        return this.generateClass(_Class2).toString();
    }

    public void generateCode(_Interface _Interface2) throws GeneratorException {
        this.generateCode(this.generateInterface(_Interface2));
    }

    public String generateCodeString(_Interface _Interface2) throws GeneratorException {
        return this.generateInterface(_Interface2).toString();
    }

    public void generateInterfaces() {
        this.generateCode(this.getMetaInterfaces());
    }

    public void generateClasses() {
        this.generateCode(this.getMetaClasses());
    }

    public void generateAll() {
        this.generateInterfaces();
        this.generateClasses();
    }

    public void generate() throws GeneratorException {
        MetaClass metaClass;
        int n;
        ArrayList<MetaClass> arrayList = new ArrayList<MetaClass>();
        if (this.interfaces != null) {
            n = 0;
            while (n < this.interfaces.length) {
                metaClass = this.generateInterface(this.interfaces[n]);
                if (metaClass != null) {
                    arrayList.add(metaClass);
                }
                ++n;
            }
        }
        if (this.classes != null) {
            n = 0;
            while (n < this.classes.length) {
                metaClass = this.generateClass(this.classes[n]);
                if (metaClass != null) {
                    arrayList.add(metaClass);
                }
                ++n;
            }
        }
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            this.generateCode((MetaClass)iterator.next());
        }
    }

    public MetaClass generateMetaClass(_Class _Class2) throws GeneratorException {
        return this.generateClass(_Class2);
    }

    public MetaClass generateMetaClass(_Interface _Interface2) throws GeneratorException {
        return this.generateInterface(_Interface2);
    }

    private MetaClass generateInterface(_Interface _Interface2) throws GeneratorException {
        if (_Interface2 == null) {
            return null;
        }
        return new MetaInterface(this.tid, this, _Interface2);
    }

    private MetaClass generateClass(_Class _Class2) throws GeneratorException {
        MetaClass metaClass = this._generateClass(_Class2);
        if (metaClass instanceof MetaSimple) {
            MetaSimple metaSimple = (MetaSimple)metaClass;
            Attribute[] attributeArray = _Class2.getAttribute();
            int n = 0;
            while (n < attributeArray.length) {
                metaSimple.appendAttrVariable(attributeArray[n]);
                metaSimple.appendAttrMethod(attributeArray[n]);
                metaSimple.appendAttrMarshal(attributeArray[n]);
                metaSimple.appendAttrUnmarshal(attributeArray[n]);
                ++n;
            }
        }
        return metaClass;
    }

    private MetaClass _generateClass(_Class _Class2) throws GeneratorException {
        if (_Class2 == null) {
            return null;
        }
        String string = _Class2.getNameText();
        Attribute[] attributeArray = _Class2.getAttribute();
        String string2 = this.getPackageName(_Class2);
        String[] stringArray = this.getInterfaceNames(_Class2);
        List list = _Class2.getChildEitherList();
        if (list.size() > 0) {
            MetaElement metaElement = new MetaElement(this.tid, this, string2, _Class2, stringArray);
            metaElement.setChildOccurrence(this.getOccurrences(list, true));
            this.processChildEither(metaElement, string, list, null);
            metaElement.getMethodBlock().toDo();
            metaElement.getValidationBlock().toDo(_Class2);
            if (this.isRootClass(_Class2)) {
                metaElement.getVariableBlock().appendDtd(this.getPublicId(), this.getSystemId());
                metaElement.getMethodBlock().toDo(_Class2);
            }
            return metaElement;
        }
        Empty empty = _Class2.getEmpty();
        if (empty != null && empty.isOn()) {
            return new MetaEmpty(this.tid, this, string2, _Class2, stringArray);
        }
        String string3 = _Class2.getPropertyNameText();
        String string4 = _Class2.getValueTypeText();
        if (string4 == null || string4.length() == 0) {
            return new MetaText(this.tid, this, string2, _Class2, stringArray, string3);
        }
        return new MetaValue(this.tid, this, string2, _Class2, stringArray, string3, string4);
    }

    private List processChildEither(MetaElement metaElement, String string, List list, String string2) {
        VariableBlock variableBlock = metaElement.getVariableBlock();
        ChildrenBlock childrenBlock = metaElement.getChildrenBlock();
        MethodBlock methodBlock = metaElement.getMethodBlock();
        MarshalBlock marshalBlock = metaElement.getMarshalBlock();
        UnmarshalBlock unmarshalBlock = metaElement.getUnmarshalBlock();
        ArrayList<XmlObject> arrayList = new ArrayList<XmlObject>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Iterator iterator2;
            Object object;
            String string3;
            String string4;
            XmlObject xmlObject;
            Object e = iterator.next();
            if (e instanceof Child) {
                xmlObject = (Child)e;
                string4 = ((Child)xmlObject).getNameText();
                string3 = ((Child)xmlObject).getOperatorText();
                object = Operator.combineOperator(string3, string2);
                if (Operator.isZeroOrMore(string2) || Operator.isOneOrMore(string2)) {
                    metaElement.addChildOp((Child)xmlObject, (String)object);
                }
                metaElement.makeChildIndex((Child)xmlObject);
                arrayList.add(xmlObject);
                methodBlock.add((Child)xmlObject);
                if (Operator.isZeroOrMore((String)object) || Operator.isOneOrMore((String)object)) {
                    variableBlock.appendRepeated((Child)xmlObject);
                    childrenBlock.appendRepeated((Child)xmlObject);
                    marshalBlock.appendRepeated((Child)xmlObject);
                    unmarshalBlock.appendRepeated(string, (Child)xmlObject);
                } else {
                    variableBlock.appendSingle((Child)xmlObject);
                    childrenBlock.appendSingle((Child)xmlObject);
                    marshalBlock.appendSingle((Child)xmlObject);
                    unmarshalBlock.appendSingle(string, (Child)xmlObject);
                }
                metaElement.addPackage(string4);
                continue;
            }
            xmlObject = (Either)e;
            string4 = ((Either)xmlObject).getOperatorText();
            string3 = Operator.combineOperator(string4, string2);
            object = ((Either)xmlObject).getLeft();
            Right right = ((Either)xmlObject).getRight();
            List list2 = null;
            if (object != null) {
                list2 = this.processChildEither(metaElement, string, ((Left)object).getChildEitherList(), string3);
            }
            List list3 = null;
            if (right != null) {
                list3 = this.processChildEither(metaElement, string, right.getChildEitherList(), string3);
            }
            if (list2 != null) {
                iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    methodBlock.addBuckets((Child)iterator2.next(), list3);
                }
                arrayList.addAll(list2);
            }
            if (list3 == null) continue;
            iterator2 = list3.iterator();
            while (iterator2.hasNext()) {
                methodBlock.addBuckets((Child)iterator2.next(), list2);
            }
            arrayList.addAll(list3);
        }
        return arrayList;
    }

    List getAllChildren(List list) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Child) {
                arrayList.add(e);
                continue;
            }
            Either either = (Either)e;
            Left left = either.getLeft();
            Right right = either.getRight();
            arrayList.addAll(this.getAllChildren(left.getChildEitherList()));
            arrayList.addAll(this.getAllChildren(right.getChildEitherList()));
        }
        return arrayList;
    }

    HashMap getOccurrences(List list, boolean bl) {
        HashMap hashMap = new HashMap();
        this.getOccurrences(list, hashMap, bl, null);
        return hashMap;
    }

    void getOccurrences(List list, HashMap hashMap, boolean bl, String string) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2;
            Object object;
            XmlObject xmlObject;
            Object e = iterator.next();
            if (e instanceof Child) {
                xmlObject = (Child)e;
                if (bl && (Operator.isZeroOrMore((String)(object = Operator.combineOperator(string2 = ((Child)xmlObject).getOperatorText(), string))) || Operator.isOneOrMore((String)object))) continue;
                string2 = ((Child)xmlObject).getNameText();
                object = (Integer)hashMap.get(string2);
                object = new Integer(object == null ? 1 : (Integer)object + 1);
                hashMap.put(string2, object);
                continue;
            }
            xmlObject = (Either)e;
            string2 = ((Either)xmlObject).getOperatorText();
            object = Operator.combineOperator(string2, string);
            Left left = ((Either)xmlObject).getLeft();
            Right right = ((Either)xmlObject).getRight();
            this.getOccurrences(left.getChildEitherList(), hashMap, bl, (String)object);
            this.getOccurrences(right.getChildEitherList(), hashMap, bl, (String)object);
        }
    }

    public static boolean isFileWithExtension(String string, String string2) {
        if (string == null || new File(string).isDirectory()) {
            return false;
        }
        String string3 = DataModel.getExtension(string);
        return string3 == null && (string2 == null || string2.length() == 0) || string3 != null && string2 != null && string3.equalsIgnoreCase(string2);
    }

    public static boolean isFileWithExtension(File file, String string) {
        return file != null && Generator.isFileWithExtension(file.getPath(), string);
    }

    public static boolean isDtdFile(String string) {
        return Generator.isFileWithExtension(string, "dtd");
    }

    public static boolean isDtdFile(File file) {
        return Generator.isFileWithExtension(file, "dtd");
    }

    public static boolean isBomFile(String string) {
        return Generator.isFileWithExtension(string, "bom");
    }

    public static boolean isBomFile(File file) {
        return Generator.isFileWithExtension(file, "bom");
    }

    public static boolean isXmlFile(String string) {
        return Generator.isFileWithExtension(string, "xml");
    }

    public static boolean isXmlFile(File file) {
        return Generator.isFileWithExtension(file, "dtd");
    }

    public static boolean isBxpFile(String string) {
        return Generator.isFileWithExtension(string, "bxp");
    }

    public static boolean isBxpFile(File file) {
        return Generator.isFileWithExtension(file, "bxp");
    }

    public BxProperty getBxProperty() {
        return this.bxPro != null ? this.bxPro : XmlUtil.getBxProperty();
    }

    public void setBxProperty(BxProperty bxProperty) {
        this.bxPro = bxProperty;
    }

    public static BxProperty createDefaultBxProperty() {
        BxProperty bxProperty = new BxProperty();
        bxProperty.setWorkingDirectoryText("");
        bxProperty.setOutputDirectoryText("");
        bxProperty.setTemplatesText("");
        bxProperty.setCustomTemplatesText("");
        bxProperty.setDefaultPcdataPropertyText("Text");
        VariableNaming variableNaming = new VariableNaming();
        bxProperty.setVariableNaming(variableNaming);
        Single single = new Single();
        single.setPrefixText("_obj");
        single.setSuffixText("");
        single.setDescriptionText("[prefix][single-elemenet-variable][suffix]");
        variableNaming.setSingle(single);
        More more = new More();
        more.setPrefixText("_obj");
        more.setSuffixText("");
        more.setDescriptionText("[prefix][multiple-elemenet-variable][suffix]");
        variableNaming.setMore(more);
        com.borland.xml.toolkit.generator.property.Attribute attribute = new com.borland.xml.toolkit.generator.property.Attribute();
        attribute.setPrefixText("");
        attribute.setSuffixText("");
        attribute.setDescriptionText("[prefix][attribute-variable][suffix]");
        variableNaming.setAttribute(attribute);
        ClassMappings classMappings = new ClassMappings();
        bxProperty.setClassMappings(classMappings);
        Mapping mapping = new Mapping();
        mapping.setSourceText("Class");
        mapping.setTargetText("_Class");
        mapping.setDescriptionText("All occurences of Class are renamed to _Class");
        classMappings.addMapping(mapping);
        mapping = new Mapping();
        mapping.setSourceText("Package");
        mapping.setTargetText("_Package");
        classMappings.addMapping(mapping);
        mapping = new Mapping();
        mapping.setSourceText("Array");
        mapping.setTargetText("_Array");
        classMappings.addMapping(mapping);
        mapping = new Mapping();
        mapping.setSourceText("Byte");
        mapping.setTargetText("_Byte");
        classMappings.addMapping(mapping);
        mapping = new Mapping();
        mapping.setSourceText("Character");
        mapping.setTargetText("_Character");
        classMappings.addMapping(mapping);
        mapping = new Mapping();
        mapping.setSourceText("Double");
        mapping.setTargetText("_Double");
        classMappings.addMapping(mapping);
        mapping = new Mapping();
        mapping.setSourceText("Float");
        mapping.setTargetText("_Float");
        classMappings.addMapping(mapping);
        mapping = new Mapping();
        mapping.setSourceText("Integer");
        mapping.setTargetText("_Integer");
        classMappings.addMapping(mapping);
        mapping = new Mapping();
        mapping.setSourceText("Long");
        mapping.setTargetText("_Long");
        classMappings.addMapping(mapping);
        mapping = new Mapping();
        mapping.setSourceText("Short");
        mapping.setTargetText("_Short");
        classMappings.addMapping(mapping);
        mapping = new Mapping();
        mapping.setSourceText("String");
        mapping.setTargetText("_String");
        classMappings.addMapping(mapping);
        DomMappings domMappings = new DomMappings();
        bxProperty.setDomMappings(domMappings);
        Adapter adapter = new Adapter();
        ParserClass parserClass = new ParserClass("org.apache.xerces.parsers.DOMParser");
        parserClass.setId("xerces");
        adapter.setParserClass(parserClass);
        adapter.setAdapterClassText("org.jdom.adapters.XercesDOMAdapter");
        adapter.setDescriptionText("");
        domMappings.addAdapter(adapter);
        adapter = new Adapter();
        parserClass = new ParserClass("org.apache.xerces.parsers.DOMParser");
        parserClass.setId("ibm4j");
        adapter.setParserClass(parserClass);
        adapter.setAdapterClassText("org.jdom.adapters.XML4JDOMAdapter");
        domMappings.addAdapter(adapter);
        adapter = new Adapter();
        adapter.setParserClassText("com.sun.xml.tree.XmlDocument");
        adapter.setAdapterClassText("org.jdom.adapters.ProjectXDOMAdapter");
        domMappings.addAdapter(adapter);
        adapter = new Adapter();
        adapter.setParserClassText("oracle.xml.parser.XMLParser");
        adapter.setAdapterClassText("org.jdom.adapters.OracleV1DOMAdapter");
        domMappings.addAdapter(adapter);
        adapter = new Adapter();
        adapter.setParserClassText("oracle.xml.parser.v2.DOMParser");
        adapter.setAdapterClassText("org.jdom.adapters.OracleV2DOMAdapter");
        domMappings.addAdapter(adapter);
        return bxProperty;
    }

    public static BxProperty createDefaultBxProperty(File file) {
        if (!Generator.isBomFile(file)) {
            return null;
        }
        BxProperty bxProperty = Generator.createDefaultBxProperty();
        bxProperty.getModels().getModel(0).setBomText(file.getAbsolutePath());
        return bxProperty;
    }

    public static BxProperty createDefaultBxProperty(File file, String string) {
        if (!Generator.isDtdFile(file)) {
            return null;
        }
        BxProperty bxProperty = Generator.createDefaultBxProperty();
        Model model = bxProperty.getModels().getModel(0);
        Dtd dtd = new Dtd();
        dtd.setNameText(file.getAbsolutePath());
        dtd.setRootElementText(string);
        return bxProperty;
    }

    private Single getSingle() {
        VariableNaming variableNaming;
        BxProperty bxProperty = this.getBxProperty();
        if (bxProperty == null || (variableNaming = bxProperty.getVariableNaming()) == null) {
            return null;
        }
        return variableNaming.getSingle();
    }

    public String getSinglePrefix() {
        Single single = this.getSingle();
        return single == null ? "_obj" : single.getPrefixText();
    }

    public String getSingleSuffix() {
        Single single = this.getSingle();
        return single == null ? "" : single.getSuffixText();
    }

    private More getMore() {
        VariableNaming variableNaming;
        BxProperty bxProperty = this.getBxProperty();
        if (bxProperty == null || (variableNaming = bxProperty.getVariableNaming()) == null) {
            return null;
        }
        return variableNaming.getMore();
    }

    public String getMorePrefix() {
        More more = this.getMore();
        return more == null ? "_obj" : more.getPrefixText();
    }

    public String getMoreSuffix() {
        More more = this.getMore();
        return more == null ? "" : more.getSuffixText();
    }

    private com.borland.xml.toolkit.generator.property.Attribute getAttribute() {
        VariableNaming variableNaming;
        BxProperty bxProperty = this.getBxProperty();
        if (bxProperty == null || (variableNaming = bxProperty.getVariableNaming()) == null) {
            return null;
        }
        return variableNaming.getAttribute();
    }

    public String getAttributePrefix() {
        com.borland.xml.toolkit.generator.property.Attribute attribute = this.getAttribute();
        return attribute == null ? "" : attribute.getPrefixText();
    }

    public String getAttributeSuffix() {
        com.borland.xml.toolkit.generator.property.Attribute attribute = this.getAttribute();
        return attribute == null ? "" : attribute.getSuffixText();
    }

    public static String getVersion() {
        return version;
    }

    public static String getVersionInfo() {
        return versionInfo;
    }

    public Translate getTranslate() {
        return this.translate;
    }

    public void setTranslate(Translate translate) {
        this.translate = translate == null ? new Translate() : translate;
    }

    protected String translateWithCallback(final String string, final MetaClass metaClass, String string2, String[][] stringArray) {
        Translate.TargetInfo targetInfo = new Translate.TargetInfo(){

            public String getTemplateName() {
                return string;
            }

            public Object getTarget() {
                return metaClass.isClass() ? metaClass.get_Class() : metaClass.get_Interface();
            }

            public boolean isSupported(Translate.TranslateCondition translateCondition) {
                if (!(translateCondition.getTemplateName() == null || translateCondition.getTemplateName().length() <= 0 || string != null && string.equals(translateCondition.getTemplateName()))) {
                    return false;
                }
                int n = translateCondition.getTranslateOn();
                if (Translate.check_TRANSLATE_ON_ALL(n)) {
                    return true;
                }
                if (Translate.check_TRANSLATE_ON_INTERFACE(n)) {
                    return !metaClass.isClass();
                }
                if (metaClass.isClass()) {
                    _Class _Class2 = metaClass.get_Class();
                    if (Translate.check_TRANSLATE_ON_ROOT_ELEMENT(n)) {
                        if (!Generator.this.isRootClass(_Class2)) {
                            return false;
                        }
                        if (Translate.check_TRANSLATE_ON_ROOT_ELEMENT_ONLY(n)) {
                            return true;
                        }
                    }
                    if (Translate.check_TRANSLATE_ON_EMPTY(n) && Generator.this.isEmptyClass(_Class2) || Translate.check_TRANSLATE_ON_ELEMENT(n) && Generator.this.isElementClass(_Class2) || Translate.check_TRANSLATE_ON_VALUE_TYPE(n) && Generator.this.hasValueType(_Class2)) {
                        return true;
                    }
                    if (Translate.check_TRANSLATE_ON_PCDATA(n) && Generator.this.isTextClass(_Class2) && (!Translate.check_TRANSLATE_ON_VALUE_TYPE(n) || Generator.this.hasValueType(_Class2))) {
                        return true;
                    }
                }
                return false;
            }
        };
        return this.translate.translateWithCallback(targetInfo, string2, stringArray);
    }

    public List traverseFromRoot(Traverse traverse) {
        return this.traverse(this.getRootClass(), traverse);
    }

    public List traverse(_Class _Class2, Traverse traverse) {
        ((HashMap)nameLocal.get()).clear();
        _Class2 = _Class2 != null ? _Class2 : this.getRootClass();
        return this.traverseChildEither(_Class2.getChildEitherList(), traverse);
    }

    private List traverseChildEither(List list, Traverse traverse) {
        ArrayList<Child> arrayList = new ArrayList<Child>();
        List list2 = this.getAllChildren(list);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Child child = (Child)iterator.next();
            HashMap hashMap = (HashMap)nameLocal.get();
            if (hashMap.containsKey(child)) continue;
            String string = child.getNameText();
            _Class _Class2 = this.findClass(string);
            hashMap.put(child, _Class2);
            if (traverse != null && traverse.test(child)) {
                arrayList.add(child);
                traverse.child(child, _Class2);
            }
            if (_Class2 == null) continue;
            arrayList.addAll(this.traverseChildEither(_Class2.getChildEitherList(), traverse));
        }
        return arrayList;
    }

    public boolean renameClass(_Class _Class2, String string) {
        final String string2 = _Class2.getNameText();
        if (string2.equals(string)) {
            return false;
        }
        List list = this.traverseFromRoot(new Traverse(){

            public boolean test(Child child) {
                return child.getNameText().equals(string2);
            }

            public void child(Child child, _Class _Class2) {
            }
        });
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Child child = (Child)iterator.next();
            child.setNameText(string);
        }
        _Class2.setNameText(string);
        this.sortClasses();
        return true;
    }

    public boolean renameClass(BxProperty bxProperty) {
        if (bxProperty == null) {
            return false;
        }
        boolean bl = false;
        BxPropertyHelper bxPropertyHelper = new BxPropertyHelper(bxProperty);
        Map map = bxPropertyHelper.getMappingMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = (String)iterator.next();
            _Class _Class2 = this.findClass(string2);
            if (_Class2 == null || !this.renameClass(_Class2, string = (String)map.get(string2))) continue;
            bl = true;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        System.out.println();
        Generator.dumpVersion();
        System.out.println();
        if (System.getProperty("GB") != null) {
            boolean bl = System.getProperty("GB").equalsIgnoreCase("force");
            Generator.generateDefaultBxProperty(bl, true);
            return;
        }
        if (stringArray.length < 1) {
            Generator.dumpHelp();
        } else {
            try {
                String string = stringArray.length < 2 ? null : stringArray[1];
                Generator generator = new Generator(stringArray[0], string);
                generator.generateAll();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static void dumpVersion() {
        System.out.println("BorlandXML " + Generator.getVersion() + " (" + Generator.getVersionInfo() + ")");
    }

    private static void dumpHelp() {
        System.out.println("Usage:");
        System.out.println("    java [-DXMLTK_HOME=home-dir] com.borland.xml.toolkit.generator.Generator");
        System.out.println("         bomfile [template-dir]");
        System.out.println("or  java [-DXMLTK_HOME=home-dir] -DGB=[force]");
        System.out.println("         com.borland.xml.toolkit.generator.Generator");
        System.out.println("\nwhere:");
        System.out.println("- XMLTK_HOME    (Optional) the home directory of BorlandXML");
        System.out.println("- bomfile       Path of *.bom file (class model file)");
        System.out.println("- template-dir\t(Optional) template directory. You can specify");
        System.out.println("                relative or absolute directory. If it is a");
        System.out.println("                relative dirctory, it is located under");
        System.out.println("                \"home-dir/template/\".");
        System.out.println("- GB            (Optional) generates the default bxpro.xml. If GB");
        System.out.println("                has the value of \"force\", bxpro.xml is always");
        System.out.println("                generated; otherwise, it is generated only when it");
        System.out.println("                does not exist. If XMLTK_HOME is provided, bxpro.xml");
        System.out.println("                is generated at the specified home dirctory;");
        System.out.println("                otherwise, it is generated at the current directory.");
        System.out.println("                If GB is not specified, no bxpro.xml is generated.");
    }

    public static File getHomeDir() {
        File file;
        File file2 = null;
        String string = System.getProperty("XMLTK_HOME");
        if (string != null && string.length() > 0 && (file = new File(string)).isDirectory()) {
            file2 = file;
        }
        if (file2 == null) {
            file2 = new File(System.getProperty("user.dir"));
        }
        return file2;
    }

    public static File getBxProFile() {
        return new File(Generator.getHomeDir(), "bxpro.xml");
    }

    public static boolean generateDefaultBxProperty(boolean bl, boolean bl2) {
        File file = Generator.getBxProFile();
        if (bl || !file.exists()) {
            try {
                BxProperty bxProperty = Generator.createDefaultBxProperty();
                bxProperty._setEncoding("UTF-8");
                bxProperty.marshal(file);
                if (bl2) {
                    System.out.println("bxpro.xml was generated at \"" + file.getAbsolutePath() + "\"");
                }
                return true;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (bl2) {
            System.out.println("bxpro.xml exists in \"" + file.getAbsolutePath() + "\"");
            System.out.println("To force BorlandXML to generate bxpro.xml, use -DGB=force");
            System.out.println("Usage:");
            System.out.println("  java [-DXMLTK_HOME=home-dir] -DGB=force com.borland.xml.toolkit.generator.Generator");
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface Traverse {
        public boolean test(Child var1);

        public void child(Child var1, _Class var2);
    }

    public static class GeneratorException
    extends Exception {
        public GeneratorException() {
        }

        public GeneratorException(String string) {
            super(string);
        }
    }
}

