/*
 * Decompiled with CFR 0.152.
 */
package com.borland.prelaunch;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.WriteAbortedException;

public class CopyWorker {
    private static final boolean verbose = false;
    private final int BUFFER_SIZE = 0x100000;
    private final byte[] buffer = new byte[0x100000];
    private String rootDir;
    private int prefixLength;
    private File targetDir;

    public CopyWorker(String string, String string2) {
        this.rootDir = string;
        this.targetDir = new File(string2);
        try {
            this.rootDir = new File(string).getCanonicalPath();
            this.targetDir.mkdir();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.prefixLength = this.rootDir.length();
    }

    public synchronized void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        while ((n = inputStream.read(this.buffer)) != -1) {
            try {
                outputStream.write(this.buffer, 0, n);
            }
            catch (IOException iOException) {
                throw new WriteAbortedException("Not enough disk space", iOException);
            }
        }
    }

    public void copyFile(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        File file2 = this.getTargetFile(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        this.copy(fileInputStream, fileOutputStream);
        fileInputStream.close();
        fileOutputStream.close();
    }

    public void copyDirectory(File file) throws IOException {
        long l = System.currentTimeMillis();
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                this.getTargetFile(file2).mkdir();
                this.copyDirectory(file2);
                continue;
            }
            this.copyFile(file2);
        }
    }

    public void copy() throws IOException {
        File file = new File(this.rootDir);
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        this.copyDirectory(file);
    }

    private File getTargetFile(File file) throws IOException {
        String string = file.getAbsolutePath();
        String string2 = file.getName();
        if (string.startsWith(this.rootDir)) {
            string2 = string.substring(this.prefixLength);
        }
        File file2 = new File(this.targetDir, string2);
        return file2;
    }
}

