/*
 * Decompiled with CFR 0.152.
 */
package com.borland.integration.tools.util;

import com.borland.integration.tools.util.Platform;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Properties;

public class OSEnvironment {
    private static Properties vars = new Properties();
    private static String[] varArray = null;

    public OSEnvironment() {
        String envFileName;
        if (vars.size() == 0 && (envFileName = System.getProperty("borland.exportenv")) != null) {
            try {
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(envFileName));
                vars.load(bis);
                bis.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public String getVariable(String varName) {
        String updatedVarName = this.updateVariableCase(varName);
        return (String)vars.get(updatedVarName);
    }

    public void setVariable(String varName, String varValue) {
        String updatedVarName = this.updateVariableCase(varName);
        if (vars.containsKey(updatedVarName)) {
            vars.remove(updatedVarName);
        }
        if (varValue != null) {
            vars.put(updatedVarName, varValue);
        }
    }

    public String[] getVariables() {
        if (varArray == null) {
            varArray = new String[vars.size()];
            Enumeration<Object> i = vars.keys();
            int pos = 0;
            while (i.hasMoreElements()) {
                String k = (String)i.nextElement();
                OSEnvironment.varArray[pos++] = k + "=" + (String)vars.get(k);
            }
        }
        return varArray;
    }

    public int getVarCount() {
        return vars.size();
    }

    public Enumeration getVariableNames() {
        return vars.keys();
    }

    private String updateVariableCase(String varName) {
        String updatedVarName = varName;
        if ("path".equalsIgnoreCase(varName)) {
            if (Platform.WIN32) {
                updatedVarName = "Path";
            } else if (Platform.UNIX) {
                updatedVarName = "PATH";
            }
        }
        return updatedVarName;
    }
}

