/*
 * Decompiled with CFR 0.152.
 */
package com.borland.integration.tools.util;

import com.borland.integration.tools.util.IniFileSection;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;

public class IniFile
extends IniFileSection {
    ArrayList fileSections = new ArrayList();
    BufferedReader inputISR;
    BufferedReader inputFR;

    public IniFile() {
        super(null);
    }

    public boolean read(InputStream inputStream) {
        this.inputISR = new BufferedReader(new InputStreamReader(inputStream));
        return this.read(this.inputISR);
    }

    public boolean read(String filename) {
        boolean bOK = true;
        try {
            this.inputFR = new BufferedReader(new FileReader(filename));
            bOK = this.read(this.inputFR);
        }
        catch (FileNotFoundException ex) {
            bOK = false;
            ex.printStackTrace();
        }
        return bOK;
    }

    public boolean read(BufferedReader input) {
        boolean bOK = true;
        try {
            String line;
            int blankLineCount = 0;
            IniFileSection currentSection = this;
            while ((line = input.readLine()) != null) {
                line.trim();
                if (line.length() == 0) {
                    ++blankLineCount;
                    continue;
                }
                if (line.charAt(0) == '[' && line.charAt(line.length() - 1) == ']') {
                    for (int i = 0; i < blankLineCount; ++i) {
                        this.add("");
                    }
                    blankLineCount = 0;
                    IniFileSection ifs = new IniFileSection(line.substring(1, line.length() - 1));
                    currentSection = ifs;
                    this.add(currentSection);
                    this.fileSections.add(ifs);
                    continue;
                }
                for (int i = 0; i < blankLineCount; ++i) {
                    currentSection.add("");
                }
                currentSection.add(line);
                blankLineCount = 0;
            }
            input.close();
        }
        catch (IOException ex) {
            bOK = false;
            ex.printStackTrace();
        }
        return bOK;
    }

    public void write(OutputStream o) {
        PrintWriter output = new PrintWriter(o);
        this.write(output);
    }

    public void write(String filename) {
        try {
            PrintWriter prnt = new PrintWriter(new FileOutputStream(filename));
            this.write(prnt);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void write(PrintWriter prnt) {
        for (int i = 0; i < this.size(); ++i) {
            Object entry = this.at(i);
            if (entry instanceof IniFileSection) {
                ((IniFileSection)entry).save(prnt);
                continue;
            }
            prnt.println(entry);
        }
        prnt.close();
    }

    public IniFileSection getSection(String name) {
        IniFileSection section = this.findSection(name);
        if (section == null) {
            section = new IniFileSection(name);
            this.add(section);
        }
        return section;
    }

    private IniFileSection findSection(String name) {
        for (int i = 0; i < this.fileSections.size(); ++i) {
            if (!this.fileSections.get(i).toString().equals(name)) continue;
            return (IniFileSection)this.fileSections.get(i);
        }
        return null;
    }

    public HashMap getSectionByMap(String name) {
        HashMap<String, String> result = new HashMap<String, String>();
        IniFileSection section = this.findSection(name);
        if (section != null) {
            for (int i = 0; i < section.size(); ++i) {
                int equal;
                String line = (String)section.at(i);
                if (line.length() <= 0 || line.charAt(0) == ';' || line.charAt(0) == '#' || (equal = line.indexOf(61)) == -1) continue;
                result.put(line.substring(0, equal), line.substring(equal + 1));
            }
        }
        return result;
    }

    public String[] getSectionContents(String name) {
        IniFileSection root = this.findSection(name);
        if (root == null) {
            return null;
        }
        ArrayList<String> contents = new ArrayList<String>();
        for (int i = 0; i < root.size(); ++i) {
            String line = (String)root.at(i);
            if (line.length() <= 0 || line.charAt(0) == ';' || line.charAt(0) == '#') continue;
            contents.add(line);
        }
        String[] result = new String[contents.size()];
        result = contents.toArray(result);
        return result;
    }

    public String toDoubleSlash(String fileName) {
        String sSubValue = "";
        if (fileName.length() > 0) {
            if (fileName.indexOf("\\") != -1) {
                int begPos = 0;
                int currPos = fileName.indexOf("\\");
                sSubValue = fileName.substring(begPos, currPos);
                while (fileName.indexOf("\\", currPos) != -1) {
                    begPos = currPos + 1;
                    if ((currPos = fileName.indexOf("\\", begPos)) == -1) {
                        currPos = fileName.length();
                    }
                    sSubValue = sSubValue + "\\\\" + fileName.substring(begPos, currPos);
                }
            }
        } else {
            sSubValue = fileName;
        }
        return sSubValue;
    }
}

