/*
 * Decompiled with CFR 0.152.
 */
package com.borland.integration.tools.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class FixedFile {
    File source;
    String cmtIndicator;

    public FixedFile(File src) {
        this.source = src;
        String fName = src.getName().toLowerCase();
        this.cmtIndicator = fName.endsWith(".properties") ? "#" : (fName.endsWith(".ini") ? ";" : (fName.endsWith(".tmp") ? ";" : (fName.endsWith(".bat") ? ";" : (fName.endsWith(".cfg") ? "#" : (fName.endsWith(".templates") ? "#" : (fName.endsWith(".html") ? "//" : "//"))))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fix(boolean justScan, boolean backup, boolean verbose, boolean overwriteExistingTemporaryFiles, boolean alwaysRemoveHeader, boolean removeHeaderOnly) {
        if (verbose) {
            System.out.println("[stripper] scanning file:" + this.source.getAbsolutePath());
        }
        BufferedReader br = null;
        PrintWriter pw = null;
        int changesMade = 0;
        int lineNo = 0;
        File tmpFile = this.getTempWorkingFile(this.source);
        File backupFile = this.getBackupFile(this.source);
        boolean isHeaderLine = false;
        try {
            Object curLine;
            if (tmpFile.exists() && !overwriteExistingTemporaryFiles) {
                System.err.println("[stripper] Temporary file already exists, scan aborted.  (" + tmpFile.getAbsolutePath() + ")");
                boolean bl = false;
                return bl;
            }
            if (backupFile.exists() && !overwriteExistingTemporaryFiles) {
                System.err.println("[stripper] Backup file already exists, scan aborted.  (" + backupFile.getAbsolutePath() + ")");
                boolean bl = false;
                return bl;
            }
            br = new BufferedReader(new FileReader(this.source));
            pw = new PrintWriter(new BufferedWriter(new FileWriter(tmpFile)));
            String bangComment = this.cmtIndicator + "!";
            while ((curLine = br.readLine()) != null) {
                ++lineNo;
                String originalLine = curLine;
                int idx = ((String)curLine).indexOf(this.cmtIndicator);
                int idxc = ((String)curLine).indexOf(bangComment);
                int idxb = idx;
                if (idx != -1) {
                    String curLine_no_spaces = this.noSpaces((String)curLine);
                    idxb = curLine_no_spaces.indexOf(this.cmtIndicator);
                    if (idxb != 0) {
                        idxb = idx;
                    }
                    if (idxc != idx && idxc != -1) {
                        idx = idxc;
                        idxb = idxc;
                    }
                    String comment = ((String)curLine).substring(idx);
                    isHeaderLine = false;
                    if (((String)curLine).indexOf("$Header") != -1) {
                        isHeaderLine = true;
                    }
                    if (comment.startsWith(bangComment) || comment.startsWith(this.cmtIndicator + "$Header") || comment.startsWith(this.cmtIndicator + " $Header") || (alwaysRemoveHeader = true & comment.indexOf("$Header") != -1)) {
                        String frontPart = idxb == 0 ? null : ((String)curLine).substring(0, idx);
                        if (verbose & !removeHeaderOnly) {
                            System.out.println("[stripper] " + lineNo + " removing comment:" + comment);
                        }
                        ++changesMade;
                        curLine = frontPart != null ? (frontPart.length() == 0 ? null : frontPart) : frontPart;
                    }
                }
                if (removeHeaderOnly) {
                    if (isHeaderLine) {
                        isHeaderLine = false;
                        curLine = null;
                        if (verbose) {
                            System.out.println("[stripper] removing header:" + originalLine);
                        }
                    } else {
                        curLine = originalLine;
                    }
                }
                if (curLine == null) continue;
                pw.println((String)curLine);
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe);
            boolean bangComment = false;
            return bangComment;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ioe) {
                System.out.println(ioe);
            }
            try {
                if (pw != null) {
                    pw.close();
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        boolean wasChanged = false;
        if (changesMade == 0 || justScan) {
            if (!tmpFile.delete()) {
                System.err.println("[stripper] Unable to delete temporary file " + tmpFile.getAbsolutePath());
            }
        } else {
            File hold = this.getRenamingFile(this.source);
            if (!this.source.renameTo(hold)) {
                System.err.println("[stripper] Unable to rename " + this.source.getAbsolutePath() + " to " + hold.getAbsolutePath());
            } else if (!tmpFile.renameTo(this.source)) {
                System.err.println("[stripper] Unable to rename " + tmpFile.getAbsolutePath() + " to " + this.source.getAbsolutePath());
            } else {
                wasChanged = true;
                if (backup) {
                    if (!hold.renameTo(backupFile)) {
                        System.err.println("[stripper] Unable to rename " + hold.getAbsolutePath() + " to " + backupFile.getAbsolutePath());
                    }
                } else if (!hold.delete()) {
                    System.err.println("[stripper] Unable to delete temprorary file:" + hold.getAbsolutePath());
                }
            }
        }
        return wasChanged;
    }

    private String noSpaces(String line) {
        boolean tab = false;
        int indx = line.indexOf(32);
        String tempLine = line;
        while (indx != -1) {
            String sbefore = tempLine.substring(0, indx);
            String safter = tempLine.substring(indx + 1, tempLine.length());
            tempLine = sbefore.concat(safter);
            indx = tempLine.indexOf(32);
        }
        int tindx = tempLine.indexOf("\t");
        while (tindx != -1) {
            String sbefore = tempLine.substring(0, tindx);
            String safter = tempLine.substring(tindx + 1, tempLine.length());
            tempLine = sbefore.concat(safter);
            tindx = tempLine.indexOf("\t");
        }
        return tempLine;
    }

    private File getTempWorkingFile(File orig) {
        return new File(orig.getAbsolutePath() + "tmp");
    }

    private File getRenamingFile(File orig) {
        return new File(orig.getAbsolutePath() + "rename");
    }

    private File getBackupFile(File source) {
        String fullPath = source.getAbsolutePath();
        int chop = fullPath.lastIndexOf(".");
        if (chop != -1) {
            fullPath = fullPath.substring(0, chop);
        }
        fullPath = fullPath.concat("backup.");
        return new File(fullPath);
    }
}

