/*
 * Decompiled with CFR 0.152.
 */
package com.borland.integration.tools.launcher.util;

import com.borland.integration.tools.launcher.dtd.Button;
import com.borland.integration.tools.launcher.dtd.ButtonAction;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.text.AttributedString;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class JInstallButton
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 1053L;
    private String buttonId;
    private Button launcherButton;
    private ButtonAction[] actionList;
    private Color btnTextColor = Color.black;
    private Font btnFont;
    private BufferedImage button;
    private BufferedImage model;
    private static int buttonWidthUnits = 13;
    private int buttonHeight = 0;
    private int buttonWidth = 0;
    private String btnText;
    private String btnToolTip;
    private boolean btnLocked;
    private String btnFontName;
    private int btnFontStyle;
    private int btnFontSize;
    private String btnMaxString;
    private TextLayout layout = null;
    private TextLayout maxLayout = null;
    private float textHeight = 0.0f;
    private float textMaxHeight = 0.0f;
    private float textWidth = 0.0f;
    private float textMaxWidth = 0.0f;
    private int textPad = 0;
    private boolean mouseIsPressed = false;
    private boolean mouseIsEntered = false;
    private boolean btnIsEnabled = false;
    private boolean isGreen = false;
    private Color ourgreen = Color.white;
    static /* synthetic */ Class class$com$borland$integration$tools$launcher$util$JInstallButton;

    public JInstallButton(String inId, Button launcherButton, String inText, String inToolTip, ButtonAction[] inActionList, boolean inLocked, String fontName, int fontStyle, int fontSize, String inColor, String maxString) {
        this.CoreSettings(inId, launcherButton, inText, inToolTip, inActionList, inLocked, fontName, fontStyle, fontSize, inColor, maxString);
        this.createButton();
    }

    private void CoreSettings(String inId, Button launcherButton, String inText, String inToolTip, ButtonAction[] inActionList, boolean inLocked, String fontName, int fontStyle, int fontSize, String inColor, String maxString) {
        this.btnFont = new Font(fontName, fontStyle, fontSize);
        this.btnText = inText;
        this.btnToolTip = inToolTip;
        this.setButtonId(inId);
        this.actionList = inActionList;
        this.launcherButton = launcherButton;
        this.btnLocked = inLocked;
        this.btnFontName = fontName;
        this.btnFontStyle = fontStyle;
        this.btnFontSize = fontSize;
        this.btnMaxString = maxString;
        if (inColor.toLowerCase().equals("green")) {
            this.isGreen = true;
        }
        if (!inText.equals("")) {
            this.btnIsEnabled = true;
        }
        Image temp = this.isGreen ? (fontSize == 10 ? new ImageIcon((class$com$borland$integration$tools$launcher$util$JInstallButton == null ? (class$com$borland$integration$tools$launcher$util$JInstallButton = JInstallButton.class$("com.borland.integration.tools.launcher.util.JInstallButton")) : class$com$borland$integration$tools$launcher$util$JInstallButton).getResource("image/Button.gif")).getImage() : new ImageIcon((class$com$borland$integration$tools$launcher$util$JInstallButton == null ? (class$com$borland$integration$tools$launcher$util$JInstallButton = JInstallButton.class$("com.borland.integration.tools.launcher.util.JInstallButton")) : class$com$borland$integration$tools$launcher$util$JInstallButton).getResource("image/Button.gif")).getImage()) : (fontSize == 10 ? new ImageIcon((class$com$borland$integration$tools$launcher$util$JInstallButton == null ? (class$com$borland$integration$tools$launcher$util$JInstallButton = JInstallButton.class$("com.borland.integration.tools.launcher.util.JInstallButton")) : class$com$borland$integration$tools$launcher$util$JInstallButton).getResource("image/ButtonSm.gif")).getImage() : new ImageIcon((class$com$borland$integration$tools$launcher$util$JInstallButton == null ? (class$com$borland$integration$tools$launcher$util$JInstallButton = JInstallButton.class$("com.borland.integration.tools.launcher.util.JInstallButton")) : class$com$borland$integration$tools$launcher$util$JInstallButton).getResource("image/Button.gif")).getImage());
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(temp, 0);
        try {
            tracker.waitForAll();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            this.model = new BufferedImage(temp.getWidth(null), temp.getHeight(null), 2);
            this.buttonHeight = this.model.getHeight();
            Graphics2D ig = this.model.createGraphics();
            ig.drawImage(temp, 0, 0, null);
            this.setPreferredSize(new Dimension(buttonWidthUnits * 3, this.buttonHeight));
            this.addMouseListener(this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void createButton() {
        if (this.btnIsEnabled) {
            FontRenderContext frc = new FontRenderContext(null, true, true);
            AttributedString str = new AttributedString(this.btnText);
            AttributedString maxStr = new AttributedString(this.btnMaxString + 100);
            str.addAttribute(TextAttribute.FONT, this.btnFont);
            maxStr.addAttribute(TextAttribute.FONT, this.btnFont);
            if (this.isGreen) {
                str.addAttribute(TextAttribute.BACKGROUND, Color.white);
                maxStr.addAttribute(TextAttribute.BACKGROUND, Color.white);
            } else {
                str.addAttribute(TextAttribute.BACKGROUND, Color.white);
                maxStr.addAttribute(TextAttribute.BACKGROUND, Color.white);
            }
            this.layout = new TextLayout(str.getIterator(), frc);
            this.maxLayout = new TextLayout(maxStr.getIterator(), frc);
            this.textWidth = this.layout.getAdvance() + 0.5f;
            this.textMaxWidth = this.maxLayout.getAdvance() + 0.5f;
            this.textHeight = this.layout.getAscent();
            this.textMaxHeight = this.maxLayout.getAscent();
            this.buttonWidth = (int)this.textMaxWidth + buttonWidthUnits * 2;
            this.textPad = (int)((float)this.buttonWidth - this.textWidth) / 2;
            this.button = new BufferedImage(this.buttonWidth, this.buttonHeight, 2);
            WritableRaster modelRaster = this.model.getRaster();
            WritableRaster btnRaster = this.button.getRaster();
            int[] buffer = modelRaster.getPixels(0, 0, buttonWidthUnits, this.buttonHeight, (int[])null);
            btnRaster.setPixels(0, 0, buttonWidthUnits, this.buttonHeight, buffer);
            buffer = modelRaster.getPixels(buttonWidthUnits + 1, 0, 1, this.buttonHeight, (int[])null);
            int i = 0;
            while ((float)i < this.textMaxWidth) {
                btnRaster.setPixels(buttonWidthUnits + i, 0, 1, this.buttonHeight, buffer);
                ++i;
            }
            buffer = modelRaster.getPixels(buttonWidthUnits * 2, 0, buttonWidthUnits, this.buttonHeight, (int[])null);
            btnRaster.setPixels(this.buttonWidth - buttonWidthUnits, 0, buttonWidthUnits, this.buttonHeight, buffer);
            this.setPreferredSize(new Dimension(this.buttonWidth + 30, this.buttonHeight));
            this.setToolTipText(this.btnToolTip);
        }
    }

    private void drawText(Graphics2D g, Color clr, boolean Pressed) {
        float HrzOffset = 0.0f;
        float VrtOffset = 0.0f;
        if (Pressed) {
            HrzOffset = 1.0f;
            VrtOffset = 1.0f;
        }
        g.setPaint(clr);
        this.layout.draw(g, (float)this.textPad + HrzOffset, this.textHeight + ((float)this.buttonHeight - this.textHeight) / 2.0f + VrtOffset - 1.0f);
    }

    public void paint(Graphics g) {
        if (this.btnIsEnabled) {
            this.btnTextColor = this.mouseIsEntered ? this.getHighlightColor() : Color.black;
            Graphics2D g2 = (Graphics2D)g;
            g2.drawImage((Image)this.button, 0, 0, null);
            this.drawText(g2, this.btnTextColor, this.mouseIsPressed);
        }
    }

    public void mouseEntered(MouseEvent e) {
        this.mouseIsEntered = true;
        Graphics g = this.getGraphics();
        this.paint(g);
    }

    public void mouseExited(MouseEvent e) {
        this.mouseIsPressed = false;
        this.mouseIsEntered = false;
        Graphics g = this.getGraphics();
        this.paint(g);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.mouseIsPressed = true;
        Graphics g = this.getGraphics();
        this.paint(g);
    }

    public void mouseReleased(MouseEvent e) {
        this.mouseIsPressed = false;
        Graphics g = this.getGraphics();
        this.paint(g);
    }

    public void setFont(Font inFont) {
        this.btnFont = inFont;
    }

    public Font getFont() {
        return this.btnFont;
    }

    public void setText(String inText) {
        this.btnText = inText;
        this.createButton();
    }

    public String getText() {
        return this.btnText;
    }

    public void setToolTip(String inToolTip) {
        this.btnToolTip = inToolTip;
        this.createButton();
    }

    public String getToolTip() {
        return this.btnToolTip;
    }

    public void setActionList(ButtonAction[] actionList) {
        this.actionList = actionList;
    }

    public ButtonAction[] getActionList() {
        return this.actionList;
    }

    public void setLocked(boolean inLocked) {
        this.btnLocked = inLocked;
    }

    public boolean getLocked() {
        return this.btnLocked;
    }

    public void setFontStyle(int inStyle) {
        this.btnFontStyle = inStyle;
    }

    public int getFontStyle() {
        return this.btnFontStyle;
    }

    public void setFontSize(int inSize) {
        this.btnFontSize = inSize;
    }

    public int getFontSize() {
        return this.btnFontSize;
    }

    public void setFontName(String inName) {
        this.btnFontName = inName;
    }

    public String getFontName() {
        return this.btnFontName;
    }

    public boolean isEnabled() {
        return this.btnIsEnabled;
    }

    public void setButtonId(String id) {
        this.buttonId = id;
    }

    public String getButtonId() {
        return this.buttonId;
    }

    public boolean getIsTabbed() {
        String isTabbed = this.launcherButton.getIsTabbed();
        if (isTabbed == null) {
            return false;
        }
        return isTabbed.equals("true");
    }

    public Color getHighlightColor() {
        return Color.red;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

