/*
 * Decompiled with CFR 0.152.
 */
package com.borland.integration.tools.launcher.util;

import com.borland.integration.tools.launcher.dtd.Action;
import com.borland.integration.tools.launcher.dtd.ButtonAction;
import com.borland.integration.tools.launcher.dtd.CheckedClass;
import com.borland.integration.tools.launcher.dtd.LauncherConfig;
import com.borland.integration.tools.launcher.dtd.Sku;
import com.borland.integration.tools.launcher.dtd.TabInfo;
import com.borland.integration.tools.launcher.state.StateUtil;
import com.borland.integration.tools.launcher.util.JInstallButton;
import com.borland.integration.tools.launcher.util.JPicturePanel;
import com.borland.integration.tools.launcher.util.LauncherXmlUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DialogSelectInstall
extends JDialog {
    private static final long serialVersionUID = 1056L;
    public static final String isAdminUserClassname = "com.borland.integration.tools.launcher.state.IsAdminUser";
    protected static Color panelColor = UIManager.getDefaults().getColor("Panel.background");
    protected static Color textColor = Color.black;
    private JPanel[] mainPanelList = null;
    private JList[] installListList = null;
    private JTextArea[] installInfoList = null;
    private boolean[] checks;
    private String[] choiceTextArray;
    private String[] choiceInfoArray;
    private boolean[] choiceAdminRequiredArray;
    private static final int valueInstall = 1;
    private static final int valueCancel = 0;
    int returnValue = 0;
    HashMap returnHashMap = new HashMap();
    private String theTitle;
    private JInstallButton theButton;
    private Sku launcherSkuConfig;
    private LauncherConfig launcherConfig;
    private ButtonAction[] theActionList;
    private JTabbedPane tabs = null;
    private int down = -1;
    private int idx;
    int numItems = 0;
    private boolean choicesLocked = false;
    private String launcherPartner = "";
    static /* synthetic */ Class class$com$borland$integration$tools$launcher$util$DialogSelectInstall;

    public DialogSelectInstall(JInstallButton button, Frame parent, String inTitle, ButtonAction[] inActionList, boolean inLocked, Sku launcherSkuConfig, LauncherConfig launcherConfig) {
        super(parent, inTitle, true);
        this.enableEvents(64L);
        try {
            this.theButton = button;
            this.theTitle = inTitle;
            this.theActionList = inActionList;
            this.choicesLocked = inLocked;
            this.launcherSkuConfig = launcherSkuConfig;
            this.launcherConfig = launcherConfig;
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getNumTabs(ButtonAction[] actionList) {
        int rslt = 1;
        for (int buttonActionNo = 0; buttonActionNo < actionList.length; ++buttonActionNo) {
            int tabNo;
            ButtonAction ba = actionList[buttonActionNo];
            if (ba.getTab() == null || (tabNo = Integer.parseInt(ba.getTab())) <= rslt) continue;
            rslt = tabNo;
        }
        return rslt;
    }

    private boolean getIsTabbed() {
        return this.theButton.getIsTabbed();
    }

    private void jbInit() throws Exception {
        boolean isTabbed = this.getIsTabbed();
        int numTabs = this.getNumTabs(this.theButton.getActionList());
        this.mainPanelList = new JPanel[numTabs];
        this.installListList = new JList[numTabs];
        this.installInfoList = new JTextArea[numTabs];
        if (!isTabbed && numTabs != 1) {
            throw new RuntimeException("Error: numtabs != 1 and isTabbed = false");
        }
        this.tabs = null;
        if (isTabbed) {
            this.tabs = new JTabbedPane(1);
            this.tabs.setMinimumSize(new Dimension(500, 350));
            this.tabs.setMaximumSize(new Dimension(500, 350));
            this.tabs.setPreferredSize(new Dimension(500, 350));
            this.tabs.getModel().addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    DialogSelectInstall.this.onTabChangedEvent(changeEvent);
                }
            });
            this.getContentPane().add(this.tabs);
        }
        this.numItems = this.theActionList.length;
        this.checks = new boolean[this.numItems];
        this.choiceTextArray = new String[this.numItems];
        this.choiceInfoArray = new String[this.numItems];
        this.choiceAdminRequiredArray = new boolean[this.numItems];
        for (int tabNo = 1; tabNo <= numTabs; ++tabNo) {
            JPicturePanel imagePanel;
            GridLayout gridLayout1 = new GridLayout();
            GridBagLayout gridBagLayout1 = new GridBagLayout();
            JPanel mainPanel = new JPanel();
            mainPanel.setLayout(gridBagLayout1);
            mainPanel.setBackground(panelColor);
            mainPanel.setMaximumSize(new Dimension(519, 370));
            mainPanel.setMinimumSize(new Dimension(519, 370));
            mainPanel.setPreferredSize(new Dimension(519, 370));
            this.launcherPartner = this.launcherSkuConfig.getPartner().getName();
            if (this.launcherPartner == null) {
                this.launcherPartner = "";
            }
            JButton btnInstall = new JButton();
            JButton btnCancel = new JButton();
            JPanel btnPanel = new JPanel();
            btnPanel.setLayout(gridLayout1);
            btnInstall.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DialogSelectInstall.this.btnInstall_actionPerformed(actionEvent);
                }
            });
            btnCancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DialogSelectInstall.this.btnCancel_actionPerformed(actionEvent);
                }
            });
            gridLayout1.setHgap(8);
            if (!isTabbed) {
                String sidePanelGraphic = this.launcherSkuConfig.getSidePanelImage();
                if (sidePanelGraphic == null || sidePanelGraphic.length() == 0) {
                    throw new RuntimeException("SidePanel must be specified");
                }
                sidePanelGraphic = "image/" + sidePanelGraphic;
                imagePanel = new JPicturePanel((class$com$borland$integration$tools$launcher$util$DialogSelectInstall == null ? DialogSelectInstall.class$("com.borland.integration.tools.launcher.util.DialogSelectInstall") : class$com$borland$integration$tools$launcher$util$DialogSelectInstall).getResourceAsStream(sidePanelGraphic));
            } else {
                imagePanel = null;
            }
            JTextArea installInfo = new JTextArea();
            JScrollPane installInfoPane = new JScrollPane(installInfo);
            installInfo.setFont(new Font("Dialog", 0, 12));
            installInfo.setLineWrap(true);
            installInfo.setMinimumSize(new Dimension(1000, 17));
            int installInfoPaneWidth = 338;
            if (isTabbed) {
                installInfoPaneWidth = 398;
            }
            installInfoPane.setPreferredSize(new Dimension(installInfoPaneWidth, 120));
            installInfoPane.setRequestFocusEnabled(true);
            installInfo.setPreferredSize(new Dimension(1000, 17));
            installInfo.setEditable(false);
            installInfo.setWrapStyleWord(true);
            installInfoPane.setVerticalScrollBarPolicy(20);
            installInfoPane.setBorder(BorderFactory.createEtchedBorder());
            installInfoPane.setMinimumSize(new Dimension(installInfoPaneWidth, 120));
            installInfo.setText("");
            installInfo.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
            this.setInstallInfo(installInfo, tabNo - 1);
            JList installList = new JList();
            JScrollPane installScrollPane = new JScrollPane(installList);
            installList.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
            String installListMinSize = this.launcherSkuConfig.getInstallListMinSizeText();
            if (installListMinSize == null || installListMinSize.length() == 0) {
                installList.setMinimumSize(new Dimension(1000, 122));
                installList.setPreferredSize(new Dimension(1000, 122));
            } else {
                installList.setMinimumSize(new Dimension(1000, Integer.parseInt(installListMinSize)));
                installList.setPreferredSize(new Dimension(1000, Integer.parseInt(installListMinSize)));
            }
            installList.setEnabled(!this.choicesLocked);
            installList.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    JList jList = (JList)mouseEvent.getSource();
                    DialogSelectInstall.this.down = jList.locationToIndex(mouseEvent.getPoint());
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    if (!DialogSelectInstall.this.choicesLocked) {
                        JList jList = (JList)mouseEvent.getSource();
                        int n = jList.locationToIndex(mouseEvent.getPoint());
                        Rectangle rectangle = jList.getBounds();
                        if (n != -1 && n == DialogSelectInstall.this.down) {
                            DialogSelectInstall.this.toggleOptionChecked(DialogSelectInstall.this.theActionList, n, DialogSelectInstall.this.getActiveUIIndex());
                            jList.repaint(rectangle);
                        }
                    }
                    DialogSelectInstall.this.down = -1;
                }
            });
            installList.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseMoved(MouseEvent mouseEvent) {
                    int n;
                    JList jList = (JList)mouseEvent.getSource();
                    int n2 = jList.locationToIndex(mouseEvent.getPoint());
                    if (n2 != (n = jList.getSelectedIndex())) {
                        jList.setSelectedIndex(n2);
                        int n3 = DialogSelectInstall.this.getInternalArrayIndex(DialogSelectInstall.this.theActionList, n2, DialogSelectInstall.this.getCurrentTab());
                        if (n2 >= 0) {
                            DialogSelectInstall.this.getInstallInfo(DialogSelectInstall.this.getActiveUIIndex()).setText(DialogSelectInstall.this.choiceInfoArray[n3]);
                        }
                    }
                    DialogSelectInstall.this.getInstallList(DialogSelectInstall.this.getActiveUIIndex()).repaint();
                }
            });
            installList.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent keyEvent) {
                    if (keyEvent.getKeyChar() == ' ' | keyEvent.getKeyChar() == '(' | keyEvent.getKeyChar() == '&') {
                        int n = DialogSelectInstall.this.getInstallList(DialogSelectInstall.this.getActiveUIIndex()).getSelectedIndex();
                        int n2 = DialogSelectInstall.this.getInternalArrayIndex(DialogSelectInstall.this.theActionList, n, DialogSelectInstall.this.getCurrentTab());
                        DialogSelectInstall.this.getInstallInfo(DialogSelectInstall.this.getActiveUIIndex()).setText(DialogSelectInstall.this.choiceInfoArray[n2]);
                        if (n != -1) {
                            DialogSelectInstall.this.toggleOptionChecked(DialogSelectInstall.this.theActionList, n, DialogSelectInstall.this.getActiveUIIndex());
                            DialogSelectInstall.this.getInstallList(DialogSelectInstall.this.getActiveUIIndex()).repaint();
                        }
                    }
                }
            });
            this.setInstallList(installList, tabNo - 1);
            installScrollPane.setBorder(BorderFactory.createEtchedBorder());
            installScrollPane.setMinimumSize(new Dimension(installInfoPaneWidth, 120));
            installScrollPane.setPreferredSize(new Dimension(installInfoPaneWidth, 100));
            JLabel lbTitle = new JLabel();
            lbTitle.setFont(new Font("Dialog", 1, 12));
            lbTitle.setForeground(textColor);
            lbTitle.setText(this.launcherSkuConfig.getInstallDialog().getDialogTitleText());
            btnPanel.setBackground(panelColor);
            JSeparator wizardSep = new JSeparator(0);
            wizardSep.setPreferredSize(new Dimension(0, 4));
            JPanel selectionPanel = new JPanel();
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            selectionPanel.setLayout(gridBagLayout2);
            selectionPanel.setBackground(panelColor);
            int selectionPanelWidth = 360;
            if (isTabbed) {
                selectionPanelWidth = 420;
            }
            selectionPanel.setMaximumSize(new Dimension(selectionPanelWidth, 305));
            selectionPanel.setMinimumSize(new Dimension(selectionPanelWidth, 305));
            selectionPanel.setPreferredSize(new Dimension(selectionPanelWidth, 305));
            if (!isTabbed) {
                imagePanel.setBorder(BorderFactory.createEtchedBorder());
            }
            JLabel lbSelComp = new JLabel();
            lbSelComp.setForeground(textColor);
            lbSelComp.setText(this.launcherSkuConfig.getInstallDialog().getSelectComponentsText());
            JLabel lbCompInfo = new JLabel();
            lbCompInfo.setText(this.launcherSkuConfig.getInstallDialog().getComponentInfoText());
            lbCompInfo.setForeground(textColor);
            btnInstall.setText(this.launcherSkuConfig.getInstallDialog().getInstallButtonText());
            btnCancel.setText(this.launcherSkuConfig.getInstallDialog().getCancelButtonText());
            this.getInstallList(tabNo - 1).setVisibleRowCount(this.numItems);
            ButtonAction[] tabActions = this.getButtonActionsByTab(this.theActionList, tabNo);
            String[] tabActionsText = new String[tabActions.length];
            for (int i = 0; i < tabActions.length; ++i) {
                String actionName = tabActions[i].getAction();
                Action actionObj = LauncherXmlUtils.getActionByName(actionName, this.launcherConfig);
                tabActionsText[i] = LauncherXmlUtils.getActionText(this.launcherSkuConfig.getName(), actionObj);
            }
            this.getInstallList(tabNo - 1).setListData(tabActionsText);
            this.getInstallList(tabNo - 1).setCellRenderer(new CheckBoxRenderer());
            btnPanel.add((Component)btnInstall, null);
            btnPanel.add((Component)btnCancel, null);
            selectionPanel.add((Component)installInfoPane, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 18, 0, new Insets(2, 2, 0, 8), 0, 0));
            selectionPanel.add((Component)installScrollPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(2, 2, 2, 8), 0, 0));
            selectionPanel.add((Component)lbCompInfo, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.05, 16, 0, new Insets(4, 2, 2, 4), 0, 0));
            selectionPanel.add((Component)lbSelComp, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.05, 16, 0, new Insets(2, 2, 2, 4), 0, 0));
            selectionPanel.add((Component)lbTitle, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.25, 16, 0, new Insets(0, 2, 2, 8), 0, 0));
            if (!isTabbed) {
                mainPanel.add((Component)imagePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 8, 2, 2), 0, 0));
            }
            mainPanel.add((Component)selectionPanel, new GridBagConstraints(1, 0, 1, 1, 0.5, 1.0, 10, 0, new Insets(4, 8, 2, 4), 0, 0));
            mainPanel.add((Component)wizardSep, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(2, 8, 4, 8), 0, 2));
            mainPanel.add((Component)btnPanel, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 12, 0, new Insets(2, 4, 8, 8), 0, 0));
            if (isTabbed) {
                TabInfo[] tabGraphicList = this.launcherSkuConfig.getTabInfo();
                String tabGraphicName = null;
                String tabCaption = null;
                for (int i = 0; i < tabGraphicList.length; ++i) {
                    TabInfo tabInfo = tabGraphicList[i];
                    if (tabInfo.getTab() == null) {
                        throw new RuntimeException("tab attribute of TabInfo element must contain a value");
                    }
                    if (Integer.parseInt(tabInfo.getTab()) != tabNo) continue;
                    tabGraphicName = tabInfo.getGraphic();
                    tabCaption = tabInfo.getCaption();
                    if (tabGraphicName != null || tabCaption != null) continue;
                    throw new RuntimeException("either the graphic or caption attribute of TabInfo element must contain a value");
                }
                if (tabGraphicName == null || tabGraphicName.length() == 0) {
                    String tabName = tabCaption;
                    this.tabs.addTab(tabName, null, mainPanel);
                } else {
                    ImageIcon tabIcon = new ImageIcon((class$com$borland$integration$tools$launcher$util$DialogSelectInstall == null ? DialogSelectInstall.class$("com.borland.integration.tools.launcher.util.DialogSelectInstall") : class$com$borland$integration$tools$launcher$util$DialogSelectInstall).getResource("image/" + tabGraphicName));
                    this.tabs.addTab(null, tabIcon, mainPanel);
                }
                this.setMainPanel(mainPanel, tabNo - 1);
                continue;
            }
            this.getContentPane().add((Component)mainPanel, "East");
        }
        for (int idx = 0; idx < this.numItems; ++idx) {
            ButtonAction buttonAction = this.theActionList[idx];
            String actionName = buttonAction.getAction();
            Action actionObj = LauncherXmlUtils.getActionByName(actionName, this.launcherConfig);
            this.choiceTextArray[idx] = LauncherXmlUtils.getActionText(this.launcherSkuConfig.getName(), actionObj);
            this.choiceInfoArray[idx] = LauncherXmlUtils.getDescriptionText(this.launcherSkuConfig.getName(), actionObj);
            String s = actionObj.getAdminrequired();
            s = s == null ? "" : s;
            this.choiceAdminRequiredArray[idx] = s.equals("true");
            int tabNo = buttonAction.getTab() != null ? Integer.parseInt(buttonAction.getTab()) : 1;
            boolean optionChecked = this.getOptionEnabledSetting(this.getInstallList(tabNo - 1), idx);
            try {
                String checkedClass;
                s = actionObj.getActionrequired();
                s = s == null ? "" : s;
                boolean actionRequired = s.equals("true");
                CheckedClass chk = actionObj.getCheckedClass();
                optionChecked = chk != null ? ((checkedClass = chk.getClassname()) != null && !checkedClass.equals("") ? (optionChecked &= StateUtil.getStateResult(checkedClass, actionObj.getId(), this.launcherConfig, this.launcherSkuConfig.getName())) : (optionChecked |= actionRequired)) : (optionChecked |= actionRequired);
            }
            catch (Exception e) {
                System.err.println("Error getting checked state for action, id=" + actionObj.getId());
                System.err.println("  " + e.getClass().getName() + "/" + e.getMessage());
            }
            this.checks[idx] = optionChecked;
        }
        this.getContentPane().setBackground(Color.gray);
        this.setForeground(Color.gray);
        this.setResizable(false);
        this.setSize(new Dimension(519, 373));
        this.setTitle(this.theTitle);
    }

    private void ProcessSelections() {
        this.idx = 0;
        while (this.idx < this.numItems) {
            if (this.checks[this.idx]) {
                this.returnHashMap.put("Action" + (this.idx + 1) + "Selection", "true");
            } else {
                this.returnHashMap.put("Action" + (this.idx + 1) + "Selection", "false");
            }
            ++this.idx;
        }
    }

    void btnInstall_actionPerformed(ActionEvent e) {
        this.returnValue = 1;
        this.ProcessSelections();
        this.dispose();
    }

    void btnCancel_actionPerformed(ActionEvent e) {
        this.returnValue = 0;
        this.dispose();
    }

    void this_windowClosing(WindowEvent e) {
        this.dispose();
    }

    boolean getOptionEnabledSetting(JList list, int index) {
        if (this.choiceAdminRequiredArray[index]) {
            try {
                return StateUtil.getStateResult(isAdminUserClassname);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return true;
            }
        }
        if (list == null) {
            return true;
        }
        return list.isEnabled();
    }

    public int getCurrentTab() {
        if (this.tabs == null) {
            return -1;
        }
        return this.tabs.getSelectedIndex();
    }

    public int getActiveUIIndex() {
        int rslt = this.getCurrentTab();
        if (rslt == -1) {
            return 0;
        }
        return rslt;
    }

    public void onTabChangedEvent(ChangeEvent e) {
    }

    private JTextArea getInstallInfo(int index) {
        return this.installInfoList[index];
    }

    private void setInstallInfo(JTextArea installInfo, int index) {
        this.installInfoList[index] = installInfo;
    }

    private JList getInstallList(int index) {
        return this.installListList[index];
    }

    private void setInstallList(JList installList, int index) {
        this.installListList[index] = installList;
    }

    private JPanel getMainPanel(int index) {
        return this.mainPanelList[index];
    }

    private void setMainPanel(JPanel mainPanel, int index) {
        this.mainPanelList[index] = mainPanel;
    }

    private ButtonAction[] getButtonActionsByTab(ButtonAction[] buttonActions, int tabNo) {
        Vector<ButtonAction> vRslt = new Vector<ButtonAction>();
        boolean isTabbed = this.getIsTabbed();
        for (int actionNo = 0; actionNo < buttonActions.length; ++actionNo) {
            ButtonAction action = buttonActions[actionNo];
            if (isTabbed) {
                int tab;
                if (action.getTab() == null || (tab = Integer.parseInt(action.getTab())) != tabNo) continue;
                vRslt.addElement(action);
                continue;
            }
            vRslt.addElement(action);
        }
        ButtonAction[] rslt = new ButtonAction[vRslt.size()];
        for (int i = 0; i < vRslt.size(); ++i) {
            rslt[i] = (ButtonAction)vRslt.elementAt(i);
        }
        return rslt;
    }

    private int getInternalArrayIndex(ButtonAction[] buttonActions, int listIndex, int tabNo) {
        int itemNo = 0;
        if (!this.getIsTabbed()) {
            return listIndex;
        }
        for (int actionNo = 0; actionNo < buttonActions.length; ++actionNo) {
            int tab;
            ButtonAction action = buttonActions[actionNo];
            if (action.getTab() != null && (tab = Integer.parseInt(action.getTab())) - 1 == tabNo && --listIndex < 0) {
                return actionNo;
            }
            ++itemNo;
        }
        return -1;
    }

    private int getListIndex(ButtonAction[] buttonActions, int internalArrayIndex, int tabNo) {
        if (!this.getIsTabbed()) {
            return internalArrayIndex;
        }
        int numTabs = this.getNumTabs(buttonActions);
        int[] listIndexes = new int[numTabs];
        for (int i = 0; i <= internalArrayIndex; ++i) {
            ButtonAction buttonAction = buttonActions[i];
            if (buttonAction.getTab() != null) {
                int tabValue = Integer.parseInt(buttonAction.getTab());
                int n = tabValue - 1;
                listIndexes[n] = listIndexes[n] + 1;
                if (tabValue != tabNo) continue;
                return listIndexes[tabNo - 1];
            }
            throw new RuntimeException("Error: tab value for ButtonAction at index " + i + " is null");
        }
        return -1;
    }

    private void toggleOptionChecked(ButtonAction[] buttonActions, int listIndex, int tabIndex) {
        int checksIndex = this.getInternalArrayIndex(buttonActions, listIndex, tabIndex);
        String actionName = buttonActions[checksIndex].getAction();
        Action actionObj = LauncherXmlUtils.getActionByName(actionName, this.launcherConfig);
        String s = actionObj.getActionrequired();
        String string = s = s == null ? "" : s;
        if (s.equals("true")) {
            String checkedClass;
            boolean checkedClassSpecified = false;
            CheckedClass chk = actionObj.getCheckedClass();
            if (chk != null && (checkedClass = chk.getClassname()) != null && !checkedClass.equals("")) {
                try {
                    checkedClassSpecified = true;
                    boolean optionChecked = StateUtil.getStateResult(checkedClass, actionObj.getId(), this.launcherConfig, this.launcherSkuConfig.getName());
                    this.checks[checksIndex] = optionChecked ? true : !this.checks[checksIndex];
                }
                catch (Exception ex) {
                    boolean bl = this.checks[checksIndex] = !this.checks[checksIndex];
                }
            }
            if (!checkedClassSpecified) {
                this.checks[checksIndex] = true;
            }
        } else {
            this.checks[checksIndex] = !this.checks[checksIndex];
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class CheckBoxRenderer
    extends JCheckBox
    implements ListCellRenderer {
        private static final long serialVersionUID = 1059L;

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setText((String)object);
            int n2 = DialogSelectInstall.this.getInternalArrayIndex(DialogSelectInstall.this.theActionList, n, DialogSelectInstall.this.getCurrentTab());
            this.setSelected(DialogSelectInstall.this.checks[n2]);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(DialogSelectInstall.this.getOptionEnabledSetting(jList, n));
            this.setFont(jList.getFont());
            this.setBorder(bl2 ? UIManager.getBorder("List.focusCellHighlightBorder") : UIManager.getBorder("List.noFocusBorder"));
            return this;
        }
    }
}

