/*
 * Decompiled with CFR 0.152.
 */
package com.borland.integration.tools.launcher.util;

import com.borland.integration.tools.launcher.util.CheckCellRenderer;
import com.borland.integration.tools.launcher.util.CheckTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;

public class CheckTreeCellEditor
extends CheckCellRenderer
implements TreeCellEditor {
    private static final long serialVersionUID = 1008L;
    protected CellEditorListener listener;
    protected CheckTreeNode currentNode;
    protected JTree tree;

    public CheckTreeCellEditor() {
        this.enableEvents(16L);
    }

    public Object getCellEditorValue() {
        return new Boolean(this.isSelected());
    }

    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        MouseEvent mouseEvent;
        if (eventObject instanceof MouseEvent && SwingUtilities.isLeftMouseButton(mouseEvent = (MouseEvent)eventObject)) {
            Point point = this.getLocation();
            if (this.hitTest(mouseEvent.getX() - point.x, mouseEvent.getY() - point.y)) {
                this.setSelected(!this.isSelected());
            }
        }
        return true;
    }

    public boolean stopCellEditing() {
        if (this.currentNode != null) {
            this.currentNode.setChecked(this.isSelected());
            this.currentNode = null;
        }
        if (this.listener != null) {
            this.listener.editingStopped(new ChangeEvent(this));
        }
        return true;
    }

    public void cancelCellEditing() {
        if (this.listener != null) {
            this.listener.editingCanceled(new ChangeEvent(this));
        }
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listener = cellEditorListener;
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        if (this.listener == cellEditorListener) {
            this.listener = null;
        }
    }

    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        this.tree = jTree;
        Color color = UIManager.getColor("Tree.selectionForeground");
        Color color2 = UIManager.getColor("Tree.selectionBackground");
        this.setForeground(color);
        this.setBackground(color2);
        if (object instanceof CheckTreeNode) {
            CheckTreeNode checkTreeNode = (CheckTreeNode)object;
            this.setIcon(checkTreeNode.getIcon());
            this.setText(checkTreeNode.getText());
            if (checkTreeNode.isCheckable()) {
                this.setSelected(checkTreeNode.isChecked());
                this.setCheckVisible(true);
                this.currentNode = checkTreeNode;
            } else {
                this.setCheckVisible(false);
            }
        } else {
            this.setText(object.toString());
            this.setCheckVisible(false);
        }
        this.setPaintFocusRect(true);
        return this;
    }

    public void setSelected(boolean bl) {
        super.setSelected(bl);
        if (this.tree != null && this.currentNode != null) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
            this.currentNode.setChecked(bl);
            defaultTreeModel.nodeChanged(this.currentNode);
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (!mouseEvent.isConsumed() && mouseEvent.getID() == 500 && SwingUtilities.isLeftMouseButton(mouseEvent) && this.hitTest(mouseEvent.getX(), mouseEvent.getY())) {
            this.setSelected(!this.isSelected());
        }
    }
}

