/*
 * Decompiled with CFR 0.152.
 */
package com.borland.integration.tools.launcher.state;

import com.jobjects.jst.RegistryException;
import com.jobjects.jst.RegistryKey;
import com.jobjects.jst.RegistryManager;
import com.jobjects.jst.SystemToolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;

public class WindowsRegistry {
    private static String DLL_FILENAME = "jst.dll";

    public WindowsRegistry() {
        if (!SystemToolkit.doesSupportRegistry()) {
            System.err.println("No registry support.");
        }
    }

    private int mapTopLevelKey(String string) {
        if (string.equals("HKEY_LOCAL_MACHINE")) {
            return 1;
        }
        if (string.equals("HKEY_CURRENT_USER")) {
            return 2;
        }
        if (string.equals("HKEY_USERS")) {
            return 3;
        }
        if (string.equals("HKEY_CLASSES_ROOT")) {
            return 4;
        }
        return 0;
    }

    public boolean keyExists(String string) throws RegistryException {
        int n;
        try {
            this.unpackDll();
        }
        catch (Exception exception) {
            throw new RegistryException("Unable to read Windows registry: cannot unpack dll (" + exception.getMessage() + ")");
        }
        String string2 = "";
        String string3 = "";
        int n2 = string.indexOf(92);
        if (n2 != -1) {
            string2 = string.substring(n2 + 1);
            string3 = string.substring(0, n2);
        }
        if ((n = this.mapTopLevelKey(string3)) == 0) {
            return false;
        }
        RegistryManager registryManager = SystemToolkit.getRegistryManager();
        RegistryKey registryKey = registryManager.openRegistryKey(n, string2);
        return registryKey.exists();
    }

    public String getValue(String string, String string2, boolean bl) throws RegistryException {
        int n;
        try {
            this.unpackDll();
        }
        catch (Exception exception) {
            throw new RegistryException("Unable to read Windows registry: cannot unpack dll");
        }
        String string3 = "";
        String string4 = "";
        int n2 = string.indexOf(92);
        if (n2 != -1) {
            string3 = string.substring(n2 + 1);
            string4 = string.substring(0, n2);
        }
        if ((n = this.mapTopLevelKey(string4)) == 0) {
            if (bl) {
                throw new RegistryException("Key does not exist");
            }
            return "";
        }
        RegistryManager registryManager = SystemToolkit.getRegistryManager();
        RegistryKey registryKey = registryManager.openRegistryKey(n, string3);
        if (!registryKey.exists()) {
            if (bl) {
                throw new RegistryException("Key does not exist");
            }
            return "";
        }
        String string5 = registryKey.getStringProperty(string2);
        if (string5 == null) {
            if (bl) {
                throw new RegistryException("Key does not exist");
            }
            return "";
        }
        return string5;
    }

    public void unpackDll() throws Exception {
        int n;
        File file = new File(DLL_FILENAME);
        if (file.exists()) {
            return;
        }
        InputStream inputStream = this.getClass().getResourceAsStream(DLL_FILENAME);
        if (inputStream == null) {
            throw new Exception("Unable to get " + DLL_FILENAME + " resource");
        }
        byte[] byArray = new byte[8192];
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        while ((n = inputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileOutputStream.flush();
        fileOutputStream.close();
        fileOutputStream = null;
        inputStream.close();
        inputStream = null;
        byArray = null;
        file.deleteOnExit();
    }
}

