/*
 * Decompiled with CFR 0.152.
 */
package com.borland.integration.tools.launcher;

import com.borland.integration.tools.launcher.dtd.Action;
import com.borland.integration.tools.launcher.dtd.Button;
import com.borland.integration.tools.launcher.dtd.ButtonAction;
import com.borland.integration.tools.launcher.dtd.Command;
import com.borland.integration.tools.launcher.dtd.LauncherConfig;
import com.borland.integration.tools.launcher.dtd.Sku;
import com.borland.integration.tools.launcher.launcher;
import com.borland.integration.tools.launcher.state.StateUtil;
import com.borland.integration.tools.launcher.util.DialogManager;
import com.borland.integration.tools.launcher.util.DialogSelectInstall;
import com.borland.integration.tools.launcher.util.JInstallButton;
import com.borland.integration.tools.launcher.util.JPicturePanel;
import com.borland.integration.tools.launcher.util.LauncherXmlUtils;
import com.borland.integration.tools.launcher.util.ProcessThread;
import com.borland.integration.tools.util.IniFile;
import com.borland.integration.tools.util.IniFileSection;
import com.borland.jbcl.layout.XYConstraints;
import com.borland.jbcl.layout.XYLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.border.Border;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = 1001L;
    JPicturePanel Page1;
    JPicturePanel Page2;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    Border border1;
    Border border2;
    JInstallButton InstallButton1;
    JInstallButton InstallButton2;
    JInstallButton InstallButton3;
    JInstallButton InstallButton4;
    JInstallButton InstallButton5;
    JInstallButton InstallButton6;
    JInstallButton InstallButton7;
    JInstallButton InstallButton8;
    JInstallButton InstallButton9;
    JInstallButton InstallButton10;
    JInstallButton InstallButton11;
    XYLayout xYLayout1 = new XYLayout();
    XYLayout xYLayout2 = new XYLayout();
    HashMap cfgResources = new HashMap();
    LauncherConfig launcherConfig = null;
    Sku launcherSkuConfig = null;
    int btnCount = 0;
    static final String DEFAULT_SKU = "ENT";
    static final String currentOS = System.getProperty("os.name").toLowerCase();
    static final String slash = System.getProperty("file.separator");
    static final boolean isMac = currentOS.substring(0, 3).equals("mac");
    static String currentLanguage = System.getProperty("user.language").toLowerCase();
    String SKU;
    String LANG;
    static DialogManager theDM;
    static final int valueInstall = 1;
    static final int valueCancel = 0;
    ProcessThread btnProcess;
    int idx;
    String launcherPartner = "";
    String msg = "";
    boolean isDialogCall = false;
    boolean isDiskChangeCall = false;
    boolean diskChangeMade = false;
    private DialogSelectInstall installDialog;
    int installDialogRV;
    HashMap installDialogHashMapRV;
    int installDialogNumItemsRV;
    String widestString;
    launcher parent;
    static /* synthetic */ Class class$com$borland$integration$tools$launcher$MainFrame;

    public MainFrame() {
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JInstallButton makeInstallButton(int buttonNo, String defaultLockedSetting, String defaultFontSetting) {
        --buttonNo;
        String launcherFont = this.launcherSkuConfig.getFont().getName();
        String buttonId = "";
        String buttonText = "";
        String buttonToolTip = "";
        String buttonColor = "";
        String buttonLocked = "";
        ButtonAction[] actionList = new ButtonAction[]{};
        Button button = null;
        if (buttonNo < this.launcherSkuConfig.getButtonCount()) {
            button = this.launcherSkuConfig.getButton(buttonNo);
            buttonId = button.getId();
            buttonText = button.getButtonTextText();
            buttonToolTip = button.getTooltipText();
            buttonColor = button.getColorText();
            buttonLocked = button.getLockedText();
            actionList = button.getButtonAction();
        }
        buttonText = buttonText == null ? "" : buttonText;
        buttonToolTip = buttonToolTip == null ? "" : buttonToolTip;
        buttonColor = buttonColor == null ? "" : buttonColor;
        buttonLocked = buttonLocked == null ? defaultLockedSetting : buttonLocked;
        launcherFont = launcherFont == null ? defaultFontSetting : launcherFont;
        JInstallButton rslt = new JInstallButton(buttonId, button, buttonText, buttonToolTip, actionList, buttonLocked.equals("true"), launcherFont, 1, 12, buttonColor, this.widestString);
        rslt.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                MainFrame.this.MainInstallLink_mouseClicked(e);
            }
        });
        return rslt;
    }

    private void jbInit() throws Exception {
        theDM = new DialogManager(this);
        this.getConfig();
        this.widestString = this.getMaxStrLen();
        String iconGraphic = this.launcherSkuConfig.getIconImage();
        if (iconGraphic == null || iconGraphic.length() == 0) {
            System.err.println("Warning: IconImage not specified");
        } else {
            iconGraphic = "image/" + iconGraphic;
            this.setIconImage(new ImageIcon((class$com$borland$integration$tools$launcher$MainFrame == null ? (class$com$borland$integration$tools$launcher$MainFrame = MainFrame.class$("com.borland.integration.tools.launcher.MainFrame")) : class$com$borland$integration$tools$launcher$MainFrame).getResource(iconGraphic)).getImage());
        }
        String mainImage = this.launcherSkuConfig.getMainImage();
        if (mainImage == null || mainImage.length() == 0) {
            throw new RuntimeException("MainImage must be specified");
        }
        String secondImage = this.launcherSkuConfig.getSecondImage();
        if (secondImage == null || secondImage.length() == 0) {
            throw new RuntimeException("SecondImage must be specified");
        }
        mainImage = "image/" + mainImage;
        secondImage = "image/" + secondImage;
        this.Page1 = new JPicturePanel((class$com$borland$integration$tools$launcher$MainFrame == null ? (class$com$borland$integration$tools$launcher$MainFrame = MainFrame.class$("com.borland.integration.tools.launcher.MainFrame")) : class$com$borland$integration$tools$launcher$MainFrame).getResourceAsStream(mainImage));
        this.Page2 = new JPicturePanel((class$com$borland$integration$tools$launcher$MainFrame == null ? (class$com$borland$integration$tools$launcher$MainFrame = MainFrame.class$("com.borland.integration.tools.launcher.MainFrame")) : class$com$borland$integration$tools$launcher$MainFrame).getResourceAsStream(secondImage));
        this.Page1.setLayout(this.xYLayout1);
        this.Page2.setLayout(this.xYLayout2);
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.launcherPartner = this.launcherSkuConfig.getPartner().getName();
        if (this.launcherPartner == null) {
            this.launcherPartner = "";
        }
        this.btnCount = this.launcherSkuConfig.getButton().length;
        this.InstallButton1 = this.makeInstallButton(1, "false", "black");
        if (this.InstallButton1.isEnabled()) {
            ++this.btnCount;
        }
        this.InstallButton2 = this.makeInstallButton(2, "false", "black");
        if (this.InstallButton2.isEnabled()) {
            ++this.btnCount;
        }
        this.InstallButton3 = this.makeInstallButton(3, "false", "black");
        if (this.InstallButton3.isEnabled()) {
            ++this.btnCount;
        }
        this.InstallButton4 = this.makeInstallButton(4, "false", "black");
        if (this.InstallButton4.isEnabled()) {
            ++this.btnCount;
        }
        this.InstallButton5 = this.makeInstallButton(5, "false", "black");
        if (this.InstallButton5.isEnabled()) {
            ++this.btnCount;
        }
        this.InstallButton6 = this.makeInstallButton(6, "false", "black");
        if (this.InstallButton6.isEnabled()) {
            ++this.btnCount;
        }
        this.InstallButton7 = this.makeInstallButton(7, "false", "black");
        if (this.InstallButton7.isEnabled()) {
            ++this.btnCount;
        }
        this.InstallButton8 = this.makeInstallButton(8, "false", "black");
        if (this.InstallButton8.isEnabled()) {
            ++this.btnCount;
        }
        this.InstallButton9 = this.makeInstallButton(9, "false", "black");
        if (this.InstallButton9.isEnabled()) {
            ++this.btnCount;
        }
        this.InstallButton10 = this.makeInstallButton(10, "false", "black");
        if (this.InstallButton10.isEnabled()) {
            ++this.btnCount;
        }
        this.InstallButton11 = this.makeInstallButton(11, "false", "black");
        if (this.InstallButton11.isEnabled()) {
            ++this.btnCount;
        }
        this.Page1.setMaximumSize(new Dimension(600, 400));
        this.Page1.setMinimumSize(new Dimension(600, 400));
        this.Page1.setPreferredSize(new Dimension(600, 400));
        int ypos = 200;
        int yinc = 35;
        this.InstallButton1.setBorder(BorderFactory.createRaisedBevelBorder());
        this.InstallButton2.setBorder(BorderFactory.createRaisedBevelBorder());
        this.Page1.add((Component)this.InstallButton1, new XYConstraints(18, ypos, -1, -1));
        this.Page1.add((Component)this.InstallButton2, new XYConstraints(18, ypos += yinc, -1, -1));
        this.Page1.add((Component)this.InstallButton3, new XYConstraints(18, ypos += yinc, -1, -1));
        this.Page1.add((Component)this.InstallButton4, new XYConstraints(18, ypos += yinc, -1, -1));
        this.Page1.add((Component)this.InstallButton5, new XYConstraints(18, ypos += yinc, -1, -1));
        this.Page1.add((Component)this.InstallButton6, new XYConstraints(18, ypos += yinc, -1, 28));
        this.Page1.add((Component)this.InstallButton7, new XYConstraints(18, ypos += yinc, -1, -1));
        this.Page1.add((Component)this.InstallButton8, new XYConstraints(18, ypos += yinc, -1, -1));
        this.Page1.add((Component)this.InstallButton9, new XYConstraints(18, ypos += yinc, -1, -1));
        this.Page1.add((Component)this.InstallButton10, new XYConstraints(18, ypos += yinc, -1, -1));
        this.Page1.add((Component)this.InstallButton11, new XYConstraints(18, ypos += yinc, -1, -1));
        ypos += yinc;
        this.getContentPane().add((Component)this.Page1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.border1 = BorderFactory.createEmptyBorder();
        this.border2 = BorderFactory.createEmptyBorder();
        this.Page1.setBorder(this.border2);
        this.setSize(new Dimension(608, 434));
        this.setTitle(this.launcherSkuConfig.getTitleText());
        MainFrameWindowListener mf = new MainFrameWindowListener();
        mf.setLauncherSkuInfo(this.launcherSkuConfig);
        this.addWindowListener(mf);
    }

    private String safeGetResource(HashMap map, String key) {
        String value = (String)map.get(key);
        String rslt = "";
        if (value != null) {
            rslt = value;
        }
        return rslt;
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            System.exit(0);
        }
    }

    public void getConfig() {
        IniFile iniAutoRun = new IniFile();
        this.launcherConfig = null;
        this.launcherSkuConfig = null;
        int space = currentOS.indexOf(32);
        if (space == -1) {
            space = currentOS.length();
        }
        if (iniAutoRun.read(launcher.cdrootInitial + slash + "autorun.inf")) {
            IniFileSection iniConfigSection = iniAutoRun.getSection("CONFIG");
            this.cfgResources = iniConfigSection.getValuesHash();
            this.SKU = (String)this.cfgResources.get("SKU");
            this.LANG = (String)this.cfgResources.get("LANG");
            if (this.LANG != null) {
                currentLanguage = this.LANG.toLowerCase();
            }
        } else {
            this.SKU = DEFAULT_SKU;
        }
        String xmlConfigFile = "launcher_" + currentOS.substring(0, space).toLowerCase();
        xmlConfigFile = currentLanguage.equals("de") || currentLanguage.equals("es") || currentLanguage.equals("fr") || currentLanguage.equals("ja") ? xmlConfigFile + "_" + currentLanguage + ".xml" : xmlConfigFile + ".xml";
        InputStream is = (class$com$borland$integration$tools$launcher$MainFrame == null ? (class$com$borland$integration$tools$launcher$MainFrame = MainFrame.class$("com.borland.integration.tools.launcher.MainFrame")) : class$com$borland$integration$tools$launcher$MainFrame).getResourceAsStream(xmlConfigFile);
        this.launcherConfig = LauncherConfig.unmarshal(is);
        if (this.launcherConfig == null) {
            System.err.println("Unable to instantiate launcher config: ");
            System.exit(1);
        }
        Sku[] skuList = this.launcherConfig.getSku();
        for (int i = 0; i < skuList.length; ++i) {
            if (!skuList[i].getName().equals(this.SKU)) continue;
            this.launcherSkuConfig = skuList[i];
            break;
        }
        if (this.launcherSkuConfig == null) {
            System.err.println("Unable to match sku in xml configuration file to sku in autorun.inf");
            System.exit(2);
        }
    }

    private String getMaxStrLen() {
        String maxValue = "";
        int buttonCount = this.launcherSkuConfig.getButtonCount();
        for (int buttonNo = 0; buttonNo < buttonCount; ++buttonNo) {
            if (this.launcherSkuConfig.getButton(buttonNo).getButtonTextText().length() <= maxValue.length()) continue;
            maxValue = this.launcherSkuConfig.getButton(buttonNo).getButtonTextText();
        }
        return maxValue;
    }

    void MainInstallLink_mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1) {
            e.consume();
        }
        try {
            JInstallButton testButton = (JInstallButton)e.getSource();
            if (testButton.getActionList().length == 1) {
                this.SingleAction_mouseClicked(e);
            } else {
                this.MultipleAction_mouseClicked(testButton);
            }
        }
        catch (Exception ex) {
            System.out.println("Exception while generating install button action: " + ex);
            ex.printStackTrace();
        }
    }

    public void paintImmediately() {
        this.Page1.paintImmediately();
    }

    public void MultipleAction_mouseClicked(JInstallButton inButton) {
        boolean errOccurred = false;
        boolean requiresReboot = false;
        String diskVerifyFile = "";
        String cdLabel = "";
        theDM.DisplayInstallDialog(inButton, inButton.getText(), inButton.getActionList(), inButton.getLocked(), this.launcherSkuConfig, this.launcherConfig);
        this.paintImmediately();
        if (theDM.getInstallDialogRV() == 1) {
            this.idx = 0;
            while (this.idx < theDM.getInstallDialogNumItemsRV()) {
                if (theDM.getInstallDialogHashMapRV().get("Action" + (this.idx + 1) + "Selection").equals("true")) {
                    String actionName = inButton.getActionList()[this.idx].getAction();
                    Action actionObj = LauncherXmlUtils.getActionByName(actionName, this.launcherConfig);
                    try {
                        boolean listAbort;
                        theDM.DisplayDelayDialog(this.launcherSkuConfig.getTitleText(), "<html><center>" + this.launcherSkuConfig.getInstallProgressMessageText() + "<br>" + LauncherXmlUtils.getActionText(this.launcherSkuConfig.getName(), actionObj) + "</center></html>");
                        this.paintImmediately();
                        Thread.sleep(5000L);
                        theDM.CloseDelayDialog();
                        this.paintImmediately();
                        boolean errorCond = false;
                        boolean needDiskPrompt = false;
                        do {
                            String sReboot;
                            errorCond = false;
                            String parsedCmd = null;
                            diskVerifyFile = "";
                            listAbort = false;
                            String diskChangeMessage = LauncherXmlUtils.getDiskChangeMessage(this.launcherSkuConfig.getName(), actionObj);
                            cdLabel = slash + LauncherXmlUtils.getCDLabelText(this.launcherSkuConfig.getName(), actionObj);
                            if (diskChangeMessage != null) {
                                this.isDiskChangeCall = true;
                                this.msg = diskChangeMessage;
                                if (actionObj.getDiskverifyfileText() != null && (diskVerifyFile = actionObj.getDiskverifyfileText()).length() > 0) {
                                    diskVerifyFile = launcher.cdroot + (launcher.isSolaris ? cdLabel : "") + slash + diskVerifyFile;
                                }
                                boolean bl = needDiskPrompt = !new File(diskVerifyFile).exists() || diskVerifyFile.length() == 0;
                                if (needDiskPrompt) {
                                    if (ProcessThread.testingLauncher()) {
                                        theDM.DisplayInfoAbortableDialog("Disk change test result", "<html><center>This file cannot be found:<br>" + diskVerifyFile + "<br>action id:" + actionObj.getId() + "</center></html>");
                                    } else {
                                        theDM.DisplayInfoAbortableDialog(this.launcherSkuConfig.getDiskChangeTitleText(), "<html><center>" + this.msg + "</center></html>");
                                    }
                                    if (theDM.getDisplayInfoAbortableDialogRV() == 0) {
                                        listAbort = true;
                                    }
                                }
                            }
                            if (listAbort) continue;
                            if (this.isDiskChangeCall && needDiskPrompt) {
                                this.paintImmediately();
                                Thread.sleep(15000L);
                            }
                            if (diskVerifyFile.length() > 0 && !new File(diskVerifyFile).exists()) {
                                errorCond = true;
                                continue;
                            }
                            if (actionObj.getRebootRequired() != null && (sReboot = actionObj.getRebootRequired().trim()).equals("true")) {
                                requiresReboot = true;
                            }
                            for (int cmdNo = 0; cmdNo < actionObj.getCommandCount(); ++cmdNo) {
                                parsedCmd = actionObj.getCommand(cmdNo).getArg();
                                if (parsedCmd.equals("DIALOG")) {
                                    String dialogMessage = actionObj.getCommand(cmdNo).getText();
                                    theDM.DisplayInfoDialog(this.launcherSkuConfig.getAdditionalActionTitleText(), "<html><center>" + dialogMessage + "</center></html>");
                                    continue;
                                }
                                parsedCmd = !parsedCmd.startsWith("@") ? launcher.cdroot + (launcher.isSolaris ? cdLabel : "") + slash + parsedCmd : parsedCmd.substring(1);
                                parsedCmd = ProcessThread.replaceTokens(parsedCmd, "$CDROOT", launcher.cdroot + (launcher.isSolaris ? cdLabel : ""));
                                this.btnProcess = new ProcessThread(this, parsedCmd);
                                this.btnProcess.setPriority(3);
                                this.btnProcess.start();
                                while (this.btnProcess.isAlive()) {
                                    Thread.sleep(200L);
                                    if (isMac) continue;
                                    this.paintImmediately();
                                }
                                if (!this.btnProcess.getErrOcurred()) continue;
                                errOccurred = true;
                            }
                        } while (errorCond);
                        listAbort = false;
                        this.isDialogCall = false;
                        this.isDiskChangeCall = false;
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
                ++this.idx;
            }
            if (!errOccurred && !isMac) {
                if (!this.diskChangeMade) {
                    theDM.DisplayInfoDialog(this.launcherSkuConfig.getTitleText(), "<html><center>" + this.launcherSkuConfig.getInstallCompleteMessageText() + "</center></html>");
                    this.paintImmediately();
                } else {
                    theDM.DisplayInfoDialog(this.launcherSkuConfig.getTitleText(), "<html><center>" + this.launcherSkuConfig.getInstallCompleteReinsertMessageText() + "</center></html>");
                    try {
                        this.paintImmediately();
                        Thread.sleep(15000L);
                        System.exit(0);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            if (requiresReboot) {
                theDM.DisplayInfoDialog(this.launcherSkuConfig.getRebootRequiredTitleText(), "<html><center>" + this.launcherSkuConfig.getRebootRequiredMessageText() + "</center></html>");
            }
        }
    }

    void SingleAction_mouseClicked(MouseEvent e) {
        boolean requiresReboot = false;
        String diskVerifyFile = "";
        String cdLabel = "";
        try {
            ButtonAction[] actionList = ((JInstallButton)e.getSource()).getActionList();
            for (int actionNo = 0; actionNo < actionList.length; ++actionNo) {
                String actionName = actionList[actionNo].getAction();
                Action actionObj = LauncherXmlUtils.getActionByName(actionName, this.launcherConfig);
                boolean listAbort = false;
                String diskChangeMessage = LauncherXmlUtils.getDiskChangeMessage(this.launcherSkuConfig.getName(), actionObj);
                cdLabel = slash + LauncherXmlUtils.getCDLabelText(this.launcherSkuConfig.getName(), actionObj);
                if (diskChangeMessage != null) {
                    this.isDiskChangeCall = true;
                    theDM.DisplayDelayDialog(this.launcherSkuConfig.getTitleText(), "<html><center>" + this.launcherSkuConfig.getInstallProgressMessageText() + "<br>" + LauncherXmlUtils.getActionText(this.launcherSkuConfig.getName(), actionObj) + "</center></html>");
                    this.paintImmediately();
                    Thread.sleep(5000L);
                    theDM.CloseDelayDialog();
                    this.msg = diskChangeMessage;
                    boolean needDiskPrompt = false;
                    if (actionObj.getDiskverifyfileText() != null && (diskVerifyFile = actionObj.getDiskverifyfileText()).length() > 0) {
                        diskVerifyFile = launcher.cdroot + (launcher.isSolaris ? cdLabel : "") + slash + diskVerifyFile;
                    }
                    boolean bl = needDiskPrompt = !new File(diskVerifyFile).exists() || diskVerifyFile.length() == 0;
                    if (needDiskPrompt) {
                        if (ProcessThread.testingLauncher()) {
                            theDM.DisplayInfoAbortableDialog("Disk change test result", "<html><center>This file cannot be found:<br>" + diskVerifyFile + "<br>action id:" + actionObj.getId() + "</center></html>");
                        } else {
                            theDM.DisplayInfoAbortableDialog(this.launcherSkuConfig.getDiskChangeTitleText(), "<html><center>" + this.msg + "</center></html>");
                        }
                        if (theDM.getDisplayInfoAbortableDialogRV() == 0) {
                            listAbort = true;
                        }
                    }
                }
                if (!listAbort) {
                    String sReboot;
                    if (this.isDiskChangeCall) {
                        this.paintImmediately();
                        Thread.sleep(12000L);
                    }
                    if (actionObj.getRebootRequired() != null && (sReboot = actionObj.getRebootRequired().trim()).equals("true")) {
                        requiresReboot = true;
                    }
                    Command[] commandList = actionObj.getCommand();
                    for (int cmdNo = 0; cmdNo < commandList.length; ++cmdNo) {
                        Command command = commandList[cmdNo];
                        String parsedCmd = command.getArg();
                        if (parsedCmd.equals("DIALOG")) {
                            String dialogMessage = actionObj.getCommand(cmdNo).getText();
                            theDM.DisplayInfoDialog(this.launcherSkuConfig.getAdditionalActionTitleText(), "<html><center>" + dialogMessage + "</center></html>");
                            continue;
                        }
                        parsedCmd = !parsedCmd.startsWith("@") ? launcher.cdroot + (launcher.isSolaris ? cdLabel : "") + slash + parsedCmd : parsedCmd.substring(1);
                        parsedCmd = ProcessThread.replaceTokens(parsedCmd, "$CDROOT", launcher.cdroot);
                        this.btnProcess = new ProcessThread(this, parsedCmd);
                        this.btnProcess.setPriority(3);
                        this.btnProcess.start();
                        while (this.btnProcess.isAlive()) {
                            Thread.sleep(200L);
                            if (isMac) continue;
                            this.paintImmediately();
                        }
                    }
                    if (requiresReboot) {
                        theDM.DisplayInfoDialog(this.launcherSkuConfig.getRebootRequiredTitleText(), "<html><center>" + this.launcherSkuConfig.getRebootRequiredMessageText() + "</center></html>");
                    }
                }
                listAbort = false;
                this.isDialogCall = false;
                this.isDiskChangeCall = false;
            }
        }
        catch (Exception ex) {
            System.out.println("Exception while generating accessory button action: " + ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MainFrameWindowListener
    extends WindowAdapter {
        private Sku launcherSkuConfig = null;

        MainFrameWindowListener() {
        }

        public void windowOpened(WindowEvent e) {
            if (System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0) {
                try {
                    if (!StateUtil.getStateResult("com.borland.integration.tools.launcher.state.IsAdminUser")) {
                        theDM.DisplayOKDialog(this.launcherSkuConfig.getAdminRequiredTitleText(), "<html>" + this.launcherSkuConfig.getAdminRequiredMessageText() + "</html>");
                        System.exit(0);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void setLauncherSkuInfo(Sku launcherSkuConfig) {
            this.launcherSkuConfig = launcherSkuConfig;
        }
    }
}

