VBoxLayout#http
{
    HBoxLayout
    {
        ComboBox#http_uri{
            size-adjust:minimum
            stretch:expand
            vtype:text
        }
    }
    
    GridLayout
    {
        column:6
        
        "${method}:" ComboBox{
            name:method
            editable:true
            vtype:text
            current:0
            
            GET,POST,OPTIONS,PUT,PATCH,TRACE
        }
        
        "${connect_timeout}:" SpinBox{
            name:connect_timeout
            max:12000
            step:1000
            suffix:ms
        }
        
        "${max_retry}:" SpinBox{
            name:max_retry
            min:0
            max:9999
        }
        
        "${max_connections}:" ComboBox{
            name:max_connections
            vtype:number
            editable:true
            max:1024
            1 2 4 8 16 32 64
        }
        
        "${max_redirect}:" SpinBox{
            name:max_redirect
            max:20
        }
        
        "${speed_limit_download}:" SpinBox{
            name:speed_limit_download
            max:9999999
            suffix:KB
            step:100
            special-text:"${unlimited}"
        }
 
     
    }
    GridLayout
    {
        column:2

        "${file_name}:" HBoxLayout
        {
            
            LineEdit{
                name:file_name
            }
            
            "${catalog}:" ComboBox#http_catalog{
                name:catalog
                vtype:data
                editable:false
                
                "  ---  "
            }
        }
        "${save_path}:" HBoxLayout
        {
            ComboBox#http_save_path
            {
                name:save_path
                vtype:text
                editable:true
                stretch:"expand"
                placeholder:"${save_path_placeholder}"
                items:$filec-paths()
            }
            Button{
                text:"..."
                click:$select-dir("${save_path}",${#http_save_path})
            }
        }
        "User Agent:" ComboBox#user_agents{
            name:user_agent
            vtype:text
            editable:true
            size-adjust:minimum
            items:$filec-user-agents()
        }
        "Cookies:" TextEdit{
            name:cookies
            //fixed-height:27
            //focused-height:60
            placeholder:"${http_cookie_placeholder}"
        }
        "Headers:" TextEdit{
            name:headers
            //fixed-height:27
            //focused-height:60
        
            placeholder:"${http_header_placeholder}"
        }
                
        "${proxy}:" HBoxLayout
        {
          
            ComboBox#http_proxy{
                name:proxy
                vtype:data
                editable:false
                
                "${no_proxy}"
            }
            <==>
        }
    }
    HBoxLayout
    {
        
        <==>
        CheckBox{
            name:ignore_remote_modified
            text:"${ignore_remote_modified}"
        }
        CheckBox{
            name:ignore_server_busy
            text:"${ignore_server_busy}"
        }
        CheckBox{
            name:ignore_http_error
            text:"${ignore_http_error}"
        }
        CheckBox{
            name:auto_rename_file
            text:"${auto_rename_file}"
        }
    }
    
}
/* 
Dialog#main
{
    layout:VBoxLayout
    ${#http}
}
*/
