EditDialog#dialog_subscribe
{
    layout:VBoxLayout
    width:400
    height:200
    title-add:"${add}"
    title-edit:"${edit}"
    form:${#dialog_subscribe}
    buttons:default
    TextEdit{
        name:url
        placeholder:"${add_subscribe_placeholder_}"
    }
}

#tab_trackers
{
    text:"${list}"
    layout:VBoxLayout

    "${downloaded_from_subscribed_url}" TextEdit#trackers_list{
        readonly:true
    }
}


#tab_subscribe
{
    text:"${subscribe}"
    layout:VBoxLayout
    Table#subscribes
    {
        sortable:true
        stripe:true
        editable:false
        stretch-last-section:false
        selection:rows
        columns-height:26
        columns:{
            {name:url,text:"URL",width:360}
            //{name:uptime,text:"${uptime}",width:130,format:datetime}
            {name:time_add,text:"${time_add}",width:130,format:datetime}
        }
        double-click:$trigger{#act_edit_subscribe}()
        context-menu:
        {
            Action#act_add_subscribe{
                text:"${add}"
                icon:"icons/24/add.svg"
                trigger:$add{#dialog_subscribe}()
            }
            Action#act_edit_subscribe{
                text:"${edit}"
                icon:"icons/16/edit.svg"
            }
            Action#act_remove_subscribe{
                text:"${delete}"
                icon:"icons/16/delete.svg"
                trigger:$filec-send("subscribe_remove",{
                    type:1,
                    id:$current-row-data{#subscribes}()
                })
            }
            Action#act_update_trackers{
                text:"${update_subscribe}"
                icon:"icons/16/update.svg"
                trigger:$filec-send("subscribe_update_trackers")
            }

        }
    }
}

#tab_settings
{
    text:"${settings}"
    layout:VBoxLayout
    GroupBox
    {
        title:"${update}"
        layout:HBoxLayout
        CheckBox{
            name:auto_update_subscribe
            text:"${auto_update_subscribe}"
        }
        CheckBox{
            name:use_proxy_update
            text:"${use_proxy_update}"
        }
        <==>
        "${auto_update_interval}:" SpinBox{
            name:auto_update_interval
            min:1
            suffix:"${hours}"
        }
    }
    GroupBox
    {
        title:"${tasks}"
        layout:VBoxLayout

        "${auto_add_trackers_to_new_task}:" TextEdit{
            name:new_task_trackers
        }
        
        HBoxLayout
        {
            CheckBox
            {
                text:"${including}: ${downloads}"
                name:including_downloads
            }
            <==>
        
            Button#save{
                text:"${save}"
                icon:"icons/16/save.svg"
            }
            Button{
                text:"${cancel}"
                icon:"icons/16/cancel.svg"
                click:$close{#main}()
            }
        }
    }
}


Dialog#main
{
    title:"${tracker}"
    width:600
    height:400
    layout:VBoxLayout

    Tab#tabs
    {
        ${#tab_trackers}
        ${#tab_subscribe}
        ${#tab_settings}
    }
} 
