@import "general.sml"
@import "network.sml"
@import "service.sml"
@import "leeches.sml"
@import "http.sml"
@import "ftp.sml"
@import "torrent.sml"
@import "ed2k.sml"

Dialog#main
{
    title:"${settings}"
    icon:"icons/24/setting.svg" 
    w:850
    h:600
    layout:VBoxLayout
    Splitter
    {
        type:horizontal
        sizes:"100,500"
        List
        {
            item-height:34
            icon-size:24
            min-width:120
            css:"background:white"
            selected:0
            bind:${#settings_widgets}
            
            {
                text:"${general}"
                icon:"icons/24/setting.svg"
            }
            {
                text:"${network}"
                icon:"icons/24/internet.svg"
            }
            {
                text:"${service}"
                icon:"icons/24/service.svg"
            }
            {
                text:"${leeches}"
                icon:"icons/24/leech.svg"
            }
            {
                text:"HTTP"
                icon:"icons/24/web.svg"
            }
            {
                text:"FTP"
                icon:"icons/24/ftp.svg"
            }
            {
                text:"Torrent"
                icon:"icons/24/torrent.svg"
            }
            {
                text:"ED2K"
                icon:"icons/24/emule.svg"
            }
        }
        Widgets#settings_widgets
        {
            value:0
            
            ${#general}
            ${#page_network}
            ${#page_service}
            ${#page_leeches}
            ${#http}
            ${#ftp}
            ${#torrent}
            ${#ed2k}
        }
        
    }
    HBoxLayout
    {
        <==>
        Button#settings_save{
            text:"${save}"
            icon:"icons/16/save.svg"
        }
        Button#settings_cancel{
            text:"${cancel}"
            click:$close{#main}()
        }
    }
    
}
