#page_general
{
    text:"${general}"
    layout:VBoxLayout
    GroupBox
    {
        layout:VBoxLayout
        title:"${display}"
        Label{
            css:"font-style:italic"
            text:"(software restart is needed)"
        }
        GridLayout
        {
            column:4
            
            "${language}:" ComboBox#gen_lang{
                stretch:expand
                vtype:data
                "${auto}"
            }
            Label{}Label{}
            
            "${fonts}:" ComboBox#gen_fonts{
                stretch:expand
                vtype:data
                "${auto}"
            }
            
            "${font_size}:" SpinBox#gen_font_size{
                stretch:expand
                min:0
                max:64
                value:0
                special-text:"${auto}"
            }
   
        }
    }
    GroupBox
    {
        title:"${program}"
        layout:{
            type:GridLayout
            column:3
        }
        CheckBox#gen_tray_icon{
            text:"${tray_icon}"
        }
        CheckBox#gen_autostart{
            text:"${autostart} (windows)"
        }
        CheckBox#gen_watch_clipboard{
            text:"${watch_clipboard}"
        }
        CheckBox#gen_sound_effects{
            text:"${sound_effects}"
        }
        CheckBox#gen_save_window_size{
            text:"${save_window_size}"
        }
        CheckBox#gen_no_refresh_address_dialog{
            text:"${no_refresh_address_dialog}"
        }
        CheckBox#gen_no_completed_dialog{
            text:"${no_completed_dialog}"
        }
    }
    GroupBox
    {
        title:"${options}"
        layout:{
            type:GridLayout
            column:3
        }
        CheckBox{
            name:system_service
            text:"${system_service} (${recommended})"
            css:"color:green"
        }
    }
    GroupBox
    {
        layout:VBoxLayout
        title:"${save}"
        
        HBoxLayout
        {
            "${default_save_path}:" PathEdit{
                name:default_save_path
                mode:dir
            }
        }
        HBoxLayout
        {
            "${save_history_path}" CheckBox{
                name:save_history_path
            }
            
            "${max_history_paths}" SpinBox{
                name:max_history_paths
            }
            <==>
        }
        /*
        HBoxLayout
        {
            "${file_exists}: "
            RadioBox{
                text:"${skip}"
            }
            RadioBox{
                text:"${rename}"
                value:true
            }
            RadioBox{
                text:"${ask}"
            }
            <==>
        }
        */
    }
    <==>
} 

#page_general_clipboard
{
    text:"${clipboard}"
    layout:VBoxLayout

    GroupBox
    {
        title:"${type}"
        layout:{
            type:GridLayout
            column:6
        }
        
        CheckBox{
            name:enable_http
            text:"HTTP"
        }
        CheckBox{
            name:enable_https
            text:"HTTPS"
        }
        CheckBox{
            name:enable_ftp
            text:"FTP"
        }
        CheckBox{
            name:enable_ftps
            text:"FTPS"
        }
        CheckBox{
            name:enable_hash
            text:"HASH"
            enable:false
            value:false
        }
        CheckBox{
            name:enable_magnet
            text:"${magnet}"
        }
        CheckBox{
            name:enable_ed2k
            text:"${ed2k}"
        }
        CheckBox{
            name:enable_filec
            text:"filec"
        }
        CheckBox{
            name:enable_fileu
            text:"fileu"
        }
        CheckBox{
            name:enable_thunder
            text:"thunder"
        }
        CheckBox{
            name:enable_flashget
            text:"flashget"
        }
        CheckBox{
            name:enable_qqdl
            text:"qqdl"
        }
    }
        
    "${matches_file_extension}:" TextEdit{
        name:suffixes
    }
}

Tab#general
{
    visible:false
    ${#page_general}
    ${#page_general_clipboard}
}

