/**
 declare QuickBuild namespace
 */
var qb = {};
String.prototype.trim = function() {return this.replace(/^\s+|\s+$/, '');};
String.prototype.startsWith = function(str) {return (this.indexOf(str) == 0);}
String.prototype.escapeJSONChars = function() {
    return this.replace(/\\n/g, "\\n")
               .replace(/\\'/g, "\\'")
               .replace(/\\"/g, '\\"')
               .replace(/\\&/g, "\\&")
               .replace(/\\r/g, "\\r")
               .replace(/\\t/g, "\\t")
               .replace(/\\b/g, "\\b")
               .replace(/\\f/g, "\\f");
};

$(function() {
	if (typeof(Wicket) != "undefined") {
		var wicketAjaxReplace = Wicket.replaceOuterHtml;
		Wicket.replaceOuterHtml = function(element, text){
			preWicketAjaxReplace(element.id);
			wicketAjaxReplace(element, text);
			postWicketAjaxReplace(element.id);
		}
	}
	
	window.onunload = function() {
		/* 
		 * add this to trigger safari page refresh when back button is clicked, this 
		 * is necessary to hide page load mask. 
		 */
	}

	$(document).mousedown(function(event) {
		var source = $(event.target);
		var popups = new Array();
		var topmostDialog = getTopmostDialog();
		var topmostDialogZIndex = 0;
		if (topmostDialog != null)
			topmostDialogZIndex = parseInt(topmostDialog.css("z-index"));
		$("body>.popup").each(function() {
			if ($(this.trigger).hasClass("open") && parseInt($(this).css("z-index")) > topmostDialogZIndex)
				popups.push(this);
		});
		popups.sort(function(a,b) {
			return parseInt($(b).css("z-index"))-parseInt($(a).css("z-index"));
		});
		for (i=0; i<popups.length; i++) {
			var popup = $(popups[i]);
			if (!contains(popup[0].trigger, source)) {
				var shouldClose = true;
				var closestPopup = source.closest(".popup");
				while (closestPopup[0]) {
					if (closestPopup[0] == popup[0]) {
						shouldClose = false;
						break;
					}
					closestPopup = $(closestPopup[0].trigger).closest(".popup");
				}
				if (shouldClose)
					closePopup(popup);
			}
		}
	});
	
	$(document).click(function(event) {
		var source = $(event.target);
		if (!event.ctrlKey && !event.altKey && !event.shiftKey && !event.metaKey && 
				(event.which == 1 || event.which == 0)) {
			if (source.closest(".maskable").length!=0)
				mask(2000);
			if (source.closest(".maskable0").length!=0)
				mask(0);
		}
	});
	$("area[title]").tooltip();
	decorateTables($(document));
	showGlobalFeedback();
	autosize(document.querySelectorAll("textarea.expand"));
	installExpander($(document));
	installFormEnterHandler($(document));
	fixIE7Palette($(document));
	
	$(window).scroll(function() {
		if ($("#global-feedback ul").length != 0) {
			var feedback = $("#global-feedback");
	        var x = ($(window).width() - feedback.outerWidth()) / 2;
	        feedback.css("left", x+$(window).scrollLeft());
			feedback.css("top", $(window).scrollTop());
		}
	});

	// auto-focus on first input element  
	$(".auto-focus:visible:first").focus();
});

function contains(container, contained) {
	if ($(container)[0] == $(contained)[0])
		return true;
	if (jQuery.contains($(container)[0], $(contained)[0]))
		return true;
	return false;
}

function decorateDashboard() {
	$(".layout-column").each(function(){
		if ($(this).find(".gadget, .gadget-placeholder").length!=0) {
			$(this).find(".column-placeholder").hide();
		} else {
			$(this).find(".column-placeholder").show();
		} 
	});
}

function showGlobalFeedback() {
	if ($("#global-feedback ul").length != 0) {
		var feedback = $("#global-feedback");
		// get feedback width after showing feedback as otherwise the feedback width
		// can not be calculated correctly in IE8.
		feedback.css("top", -10000);
		feedback.show();
        var x = ($(window).width() - feedback.outerWidth()) / 2;
        feedback.hide();
        feedback.css("left", x+$(window).scrollLeft());
		feedback.css("top", $(window).scrollTop());
		$("#global-feedback").slideDown("slow");
		setTimeout("$('#global-feedback').slideUp();", 6000);
	}
}

function insertAfter(newElement,targetElement) {
	//target is what you want it to go after. Look for this elements parent.
	var parent = targetElement.parentNode;
	if(parent.lastchild == targetElement)
		parent.appendChild(newElement);
	else 
		parent.insertBefore(newElement, targetElement.nextSibling);
}

/*
 * redraw palette selection boxes when choice is changed in IE7, otherwise 
 * choices may not be rendered correctly. 
 */
function fixIE7Palette(container) {
	if ($.browser.msie && $.browser.version.startsWith("7.0")) {
		container.find("table.palette button.button").click(function(event) {
			container.find("table.palette select").hide();
			container.find("table.palette select").show();
		});
		container.find("table.palette select").dblclick(function(event) {
			container.find("table.palette select").hide();
			container.find("table.palette select").show();
		});
	}
}

function replaceHtml(el, html) {
	var oldEl = typeof el === "string" ? document.getElementById(el) : el;
	var newEl = oldEl.cloneNode(false);
	newEl.innerHTML = html;
	oldEl.parentNode.replaceChild(newEl, oldEl);
	return newEl;
};

function updateLog(buildId, stepPath, fromIndexes, showStep) {
	if ($(".livelog").length > 0) {
		var postData = {
				"fromIndexes": fromIndexes, 
				"buildId": buildId,
				"stepPath": stepPath,
				"showStep": showStep
		};
		$.post("/log_request/live", 
			JSON.stringify(postData).escapeJSONChars(), 
			onSuccess);
	}
	
	function onSuccess(json) {
		var $livelog = $(".livelog");
		var $loadingContent = $livelog.find(".loading-content");
		if ($loadingContent.length != 0) {
			if (json.truncated) 
				$loadingContent.before("<div class='log-truncated'>Start of the log is truncated as there are too many entries</div>");
			if (json.logContent.length != 0) {
				var topOfLoadingContent = $loadingContent.offset().top;
				$loadingContent.before(json.logContent);	
		        if (topOfLoadingContent < $(window).height() + $(window).scrollTop()) {
		        	$("html, body").scrollTop($(document).height());
		        } 		
		    }
			if (json.finished) {
				$livelog.find(".loading-content").remove();
			} else {
				setTimeout(function() {
					updateLog(buildId, stepPath, json.fromIndexes, showStep);
				}, 5000);
			}
		}
	}
}

function retrieveLog(log, showStep) {
	// use post instead of get as IE caches ajax request result
	// in case of a get call

	// retrieve message after some time so that load mask can be displayed
	setTimeout(function() {
		$.post("/log_request/render", {log:log, showStep:showStep}, onSuccess, "text");	
	}, 250);
	
	function onSuccess(data) {
		replaceHtml("log-content", data);
		if (qb.anchorDate) {
			scrollLogTo(qb.anchorDate);
			qb.anchorDate = undefined;
		}
	}
}

function preWicketAjaxReplace(elementId) {
	clearPopups($("#" + elementId));
}

function clearPopups(element) {
	$("body>.popup").each(function() {
		var popup = $(this);
		var trigger = $(this.trigger);
		if (contains($(element)[0], trigger[0])) {
			if (trigger.hasClass("open"))
				closePopup(popup);
			popup.remove();
		}
	});
}

function postWicketAjaxReplace(elementId) {
	var element = $("#" + elementId);
	var popup = element.closest(".popup");
	if (popup[0]) {
		if ($(popup[0].trigger).hasClass("open")) {
			popup.children().addClass("content");
			popup.css({left:-10000, top:-10000});
			popup.align(popup[0].alignment).show();
		} else {
			closePopup(popup);
		}
	}
	element.find("area[title]").tooltip();
	decorateTables(element.parent());
	installExpander(element);
	fixIE7Palette(element);
	installFormEnterHandler(element);
	
	autosize(document.querySelectorAll("textarea.expand"));
	element.find(".auto-focus:visible:first").focus(); 
	element.find(".auto-focus:visible:first").focus(); 
}

function installFormEnterHandler(container) {
	if ($.browser.msie && ($.browser.version.startsWith("7.0") || $.browser.version.startsWith("8.0"))) {
		container.find("form").each(function() {
			var submitBtns = $(this).find("input[type=submit]");
			if (submitBtns.length != 0 && submitBtns[0].onclick != null && submitBtns[0].onclick != undefined) {
				$(this).find("input[type=text]").each(function() {
					$(this).keypress(function(event) {
						if (wicketKeyCode(event) == 13) { 
							$(submitBtns[0]).click();
							return false;
						};
					});
					$(this).attr("autocomplete", "off");
				});
			}
		});
	}
}

function decorateTables(container) {
	container.find("table.oddeven").each(function() {
		if (this.tableDecorated != true) {
			$(this).find("tbody tr").each(function(j) {
				if (j % 2 == 0)
					$(this).addClass("even");
				else
					$(this).addClass("odd");
			});
			this.tableDecorated = true;
		}
	});
}

function installExpander(container) {
	container.find(".expandable").each(function() {
		if (this.expanderInstalled != true) { 
			var expander = $(document.createElement("img"));
			var input = $(this);
			expander.attr("src", "/images/lines.png");
			expander.attr("title", "Expand to multiple lines");
			expander.click(function() {
				expander.hide();
				var value = input.val();
				var cssClass = input.attr("class");
				var style = input.attr("style");
				var id = input.attr("id");
				var name = input.attr("name");

				var textarea = $(document.createElement("textarea"));
				textarea.val(value + "\n");
				if (cssClass != undefined)
					textarea.attr("class", cssClass);
				if (style != undefined)
					textarea.attr("style", style);
				if (id != undefined)
					textarea.attr("id", id);
				if (name != undefined)
					textarea.attr("name", name);
				input.replaceWith(textarea);

				textarea.css("min-height", "18px").css("max-height", "450px");
				autosize(textarea[0]);
				textarea.focus();
				textarea.focus(); // add extra focus to fix IE issue
				
				// below code moves cursor to the end of text
			    if (textarea[0].setSelectionRange) {
			    	var len = textarea.val().length * 2;
			    	textarea[0].setSelectionRange(len, len);
			    } else {
			    	textarea.val(textarea.val());
			    }
			    textarea[0].scrollTop = 999999;
			});
			expander.attr("style", "margin-right:-9px; vertical-align:center; position:relative;");
			expander.insertBefore(input);
			this.expanderInstalled = true;
		}
	});
}

function openPopup(popup, alignment) {
	var trigger = $(popup[0].trigger);
	popup[0].alignment = alignment;

	var parentPopup = trigger.closest(".popup, .ui-dialog");
	if (parentPopup[0]) 
		popup.css("z-index", parseInt(parentPopup.css("z-index")) + 10);

	trigger.addClass("open");
	trigger.removeClass("close");

	if (alignment.target) {
		$(alignment.target).addClass("open");
		$(alignment.target).removeClass("close");
	}
	if (trigger[0].path) {
		if (trigger[0].showLoadIndicator)
			popup.align(alignment).show();
		loadPopup(trigger[0].path);
	} else {
		popup.align(alignment).show();
	}
}

function getTopmostPopup() {
	var maxZIndex = 0;
	var topmostPopup = null;
	$("body>.popup").each(function() {
		if ($(this.trigger).hasClass("open")) {
			zIndex = $(this).css("z-index");
			if (maxZIndex < zIndex) {
				maxZIndex = zIndex;
				topmostPopup = $(this);
			}
		}
	});
	return topmostPopup;
}

function closeTopmostPopup() {
	var topmostPopup = getTopmostPopup();
	if (topmostPopup != null)
		closePopup(topmostPopup);
}

function getTopmostDialog() {
	var maxZIndex = 0;
	var topmostDialog = null;
	$("body>.ui-dialog").each(function() {
		if ($(this).is(":visible")) {
			zIndex = $(this).css("z-index");
			if (maxZIndex < zIndex) {
				maxZIndex = zIndex;
				topmostDialog = $(this);
			}
		}
	});
	return topmostDialog;
}

function closePopup(popup) {
	var trigger = $(popup[0].trigger);
	trigger.addClass("close");
	trigger.removeClass("open");
	if (popup[0].alignment.target) {
		$(popup[0].alignment.target).addClass("close");
		$(popup[0].alignment.target).removeClass("open");
	}
	popup.hide();
	if (trigger[0].path) {
		var content = popup.children();
		clearPopups(content[0]);
		popup.html("<div id='" + content[0].id + 
				"' class='content'><img src='/images/ajax-indicator.gif'></img> Loading...</div>");
		unloadPopup(trigger[0].path);
	}
}

function createDialog(dialogId, dialogOptions) {
	var dialog = $("<div><div id='" + dialogId + 
			"'><img src='/images/ajax-indicator.gif'/> Loading...</div></div>");
	$("body").append(dialog);
	dialog.dialog(dialogOptions);
}

function destroyDialog(dialogId) {
	var dialog = $("#" + dialogId).parent();
	clearPopups(dialog);
	dialog.dialog("destroy");
	dialog.remove();
}

function setupPopup(triggerId, popupId, triggerPath, hoverMode, showLoadIndicator, 
		alignmentTargetId, alignmentTargetX, alignmentTargetY, alignmentPopupX, alignmentPopupY) {
	var alignment = {};
	alignment.target = $("#" + alignmentTargetId)[0];
	alignment.targetX = alignmentTargetX;
	alignment.targetY = alignmentTargetY;
	alignment.x = alignmentPopupX;
	alignment.y = alignmentPopupY;
	
	var trigger = $("#" + triggerId);
	trigger[0].path = triggerPath;
	trigger[0].showLoadIndicator = showLoadIndicator;
	var popup = $("<div><div id='" + popupId + 
			"' class='content'><img src='/images/ajax-indicator.gif'/> Loading...</div></div>");
	trigger.popup(popup, hoverMode, alignment);
}

function scrollLogTo(date) {
	var anchor = null;
	$("#log-content").find("a").each(function() {
		if (this.name <= date)
			anchor = this.name;
		else
			return false;
	});
	if (anchor != null)
		self.location.hash= "#" + anchor;
}

function encrypt(element) {
	$.post("/encrypt", element.value, function(data) {element.value = data;});
}

function shrinkColumn(id) {
	var td = $("#" + id).closest("td")[0];
	if (td && $(td).hasClass("column")) {
		$(td).addClass("shrink");
	}
}

function setupDraggable(dragSelector, dragData, dragText) {
	$(dragSelector).draggable({
		cursor: 'pointer',
		cursorAt: {left:12,top:12},
		helper: function(event) {
			if (dragText)
				return $('<span title="' + dragData + '">' + dragText + '</span>');
			else
				return $('<img src="/images/drag-helper.png" title="' + dragData + '"></img>');
		}
	});
}

function setupDroppable(dropSelector, acceptSelector, dropPath) {
	$(dropSelector).droppable({
		hoverClass: 'drag-over',
		greedy: true,
		tolerance: 'pointer',
		accept: acceptSelector,
		drop: function(event, ui) {
			onDrop(ui.helper.attr("title"), dropPath);
		}
	});
}

function mask(timeout) {
	if (timeout == 0) { // disable mask temporarily except for server setup page
		setTimeout(function() {
			$("#page-load-msg").center();
			$("#page-load-mask").show();
			$("#page-load-msg").show();
		}, timeout);
	}
}	

function openDialog(dialog) {
	var topmostPopup = getTopmostPopup();
	if (topmostPopup != null) {
		var topmostPopupZIndex = parseInt(topmostPopup.css("z-index"));
		var dialogZIndex = dialog.dialog("option", "zIndex");
		if (topmostPopupZIndex > dialogZIndex)
			dialog.dialog("option", "zIndex", topmostPopupZIndex+10);
	} 
	dialog.dialog("open");
}

function confirmDlg(message, callback) {
	var dialog = $("#confirm-dlg");
	dialog.html("<div class='confirm'>" + message + "</div>");
	dialog.dialog({
		autoOpen:false,
		modal: true,
		width: 500,
		dialogClass: "confirm-dlg",
		title: "Please Confirm",
		resizable: false,
		buttons: {
			"Ok": function() {
				$(this).dialog("close");
				callback();
			},
			"Cancel": function() {
				$(this).dialog("close");
			}
		}
	});
	openDialog(dialog);
}

function setupColorEditor(inputId, triggerId) {
	$("#" + inputId + ", #" + triggerId).ColorPicker({
		onSubmit: function(hsb, hex, rgb, el) {
			document.getElementById(inputId).value = "#" + hex;
			$(el).ColorPickerHide();
		},
		onBeforeShow: function () {
			var value = document.getElementById(inputId).value.trim();
			if (value.length != 0)
				value = value.substring(1);
			$(this).ColorPickerSetColor(value);
		}
	}).bind('keyup', function(){
		$(this).ColorPickerSetColor(document.getElementById(inputId).value);
	});	
}