jQuery.fn.popup = function(popup, hoverMode, alignment) {
	var trigger = this;
	trigger.addClass("popup-trigger close");
	if (hoverMode)
		trigger.addClass("hover-mode");
	
	$("body").append(popup);
	popup.addClass("popup");
	popup[0].trigger = trigger[0];
	if (alignment!=undefined)
		$(alignment.target).addClass("popup-target close");

	if (hoverMode) {
		function hide() {
			var topmostPopup = getTopmostPopup();
			if (topmostPopup[0] == popup[0]) {
				var topmostDialog = getTopmostDialog();
				if (topmostDialog == null || 
						parseInt(topmostDialog.css("z-index")) < parseInt(topmostPopup.css("z-index"))) {
					closePopup(popup);
				}
			}
			trigger.hideTimer = null;
		}
		function prepareToHide() {
			if (trigger.hideTimer != null) 
				clearTimeout(trigger.hideTimer);
			trigger.hideTimer = setTimeout(function(){
				if (trigger.hasClass("open"))
					hide();
			}, 350);
		}
		function cancelHide() {
			if (trigger.hideTimer != null) {
				clearTimeout(trigger.hideTimer);
				trigger.hideTimer = null;				
			} 
		}
		function cancelShow() {
			if (trigger.showTimer != null) {
				clearTimeout(trigger.showTimer);
				trigger.showTimer = null;
			}
		}
		trigger.mouseover(function(mouse){
			if (!trigger.showTimer) {
				trigger.showTimer = setTimeout(function() {
					if (trigger.hasClass("close")) {
						openPopup(popup, alignment!=undefined?alignment:mouse);
						cancelHide();
					}
					trigger.showTimer = null;
				}, 350);
			}
		});
		popup.mouseover(function() {
			cancelHide();
		});
		trigger.mouseout(function() {
			prepareToHide();
			cancelShow();
		});
		trigger.mousemove(function() {
			cancelHide();
		});
		popup.mouseout(function(event) {
			if (event.pageX<popup.offset().left+5 || event.pageX>popup.offset().left+popup.width()-5 
					|| event.pageY<popup.offset().top+5 || event.pageY>popup.offset().top+popup.height()-5) {
				prepareToHide();
			}
		});
	} else {
		trigger.click(function(mouse) {
			if (trigger.hasClass("close")) 
				openPopup(popup, alignment!=undefined?alignment:mouse);
			else 
				closePopup(popup);
			return false;
		});
	}
	
	return this;
};
