import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;

/*
 * This sample demonstrates how to search successful builds in a configuration.
 *
 * IMPORTANT: Make sure to check QuickBuild server log if you get exceptions reporting 
 * a 500 response status.
 */
public class SearchBuilds {
    
    @SuppressWarnings("unchecked")
    public static void main(String[] args) throws IOException, DocumentException {
        Client client = Client.create();
        client.addFilter(new HTTPBasicAuthFilter("admin", "admin"));
        String configurationId = client.resource("http://localhost:8810/rest/ids")
        		.queryParam("configuration_path", "root/test").get(String.class);

        String buildsXML = client.resource("http://localhost:8810/rest/builds")
        		.queryParam("configuration_id", configurationId)
        		.queryParam("status", "SUCCESSFUL").get(String.class);
        Document dom = new SAXReader().read(new StringReader(buildsXML));
        System.out.println("Found builds:");
        for (Element element: (List<Element>) dom.getRootElement().elements())
            System.out.println(element.elementText("version"));
    }
}
