import java.util.ArrayList;
import java.util.List;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;

/*
 * This sample demonstrates how to create users and assign them to the developer group. 
 * 
 * IMPORTANT: Make sure to check QuickBuild server log if you get exceptions reporting 
 * a 500 response status.
 */
public class CreateUsers {

    public static void main(String[] args) {
        List<User> users = new ArrayList<User>();
        users.add(new User("robin", "12345", "Robin Shine", "robin@example.com"));
        users.add(new User("steve", "12345", "Steve Luo", "steve@example.com"));
        users.add(new User("william", "12345", "William Ford", "william@example.com"));

        Client client = Client.create();
        client.addFilter(new HTTPBasicAuthFilter("admin", "admin"));
        String groupId = client.resource("http://localhost:8810/rest/ids")
        		.queryParam("group_name", "developer").get(String.class);
        
        for (User user: users) {
            String userXML =
                    "<com.pmease.quickbuild.model.User>" +
                    "  <name>" + user.getLoginName() + "</name>" +
                    "  <password>" + user.getPassword() + "</password>" +
                    "  <fullName>" + user.getFullName() + "</fullName>" +
                    "  <email>" + user.getEmail() + "</email>" +
                    "  <pluginSettingDOMs/>" +
                    "</com.pmease.quickbuild.model.User>";
            // create user
            String userId = client.resource("http://localhost:8810/rest/users").post(String.class, userXML);
            System.out.println("User '" + user.getLoginName() + "' is created.");

            // associate created user with group
            String membershipXML =
                    "<com.pmease.quickbuild.model.Membership>" +
                    "  <user>" + userId + "</user>" +
                    "  <group>" + groupId + "</group>" +
                    "</com.pmease.quickbuild.model.Membership>";
            client.resource("http://localhost:8810/rest/memberships").post(membershipXML);
            System.out.println("User '" + user.getLoginName() + "' is associated with the developer group.");
        }
    }

    private static class User {
        private String loginName;

        private String password;

        private String fullName;

        private String email;

        public User(String loginName, String password, String fullName, String email) {
            this.loginName = loginName;
            this.password = password;
            this.fullName = fullName;
            this.email = email;
        }

        public String getLoginName() {
            return loginName;
        }

        public String getPassword() {
            return password;
        }

        public String getFullName() {
            return fullName;
        }

        public String getEmail() {
            return email;
        }

    }
}
