package com.pmease.quickbuild.plugin.tracker.redmine;

import java.util.Collection;
import java.util.Map;

import com.google.common.collect.Maps;
import com.pmease.quickbuild.plugin.tracker.core.AbstractIssueTracker;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.Issue;
import com.pmease.quickbuild.plugin.tracker.core.utils.StringHelper;
import com.pmease.quickbuild.plugin.tracker.core.utils.TrackerHelper;

public class RedmineTracker extends AbstractIssueTracker {

	private static final long serialVersionUID = 1L;

	public Map<String, Issue> fetchIssues(Collection<String> keys) {
		Map<String, Issue> issues = Maps.newLinkedHashMap();
		RedmineCli cli = RedmineCli.newInstance();
		for (String each : keys) {
			Issue issue = cli.getIssue(each);
			if (issue != null) {
				issues.put(each, issue);
			}
		}
		return issues;
	}

	public String getIssueUrlPattern() {
		RedmineSetting setting = RedmineSetting.get();
		return StringHelper.normalizeUrl(setting.getHost()) + "/issues/$KEY";
	}
	
	@Override
	public String extractIssueKey(final String matched) {
		Long id = TrackerHelper.extractLong(matched);
		if (id == null) {
			return null;
		} else {
			return id.toString(); 
		}
	}
	
}
