package com.pmease.quickbuild.plugin.tracker.redmine;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.extensionpoint.StepProvider;
import com.pmease.quickbuild.extensionpoint.support.Gadget;
import com.pmease.quickbuild.plugin.tracker.core.AbstractTrackerPlugin;
import com.pmease.quickbuild.plugin.tracker.core.IssueCategory;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.IssueTracker;
import com.pmease.quickbuild.stepsupport.Step;

public class RedminePlugin extends AbstractTrackerPlugin {

	@Override
	public IssueTracker createTracker() {
		return new RedmineTracker();
	}

	@Override
	protected IssueCategory createCategory() {
		return new RedmineCategory();
	}

	@Override
	public Class<?> getConfigurationSettingClass() {
		return RedmineSetting.class;
	}
	
	@Override
	@SuppressWarnings("unchecked")
	protected Class<? extends Gadget>[] getGadgetClasses() {
		return new Class[] { RedmineGadget.class };
	}
	
	@Override
	protected Class<?>[] getRestResourceClasses() {
		return new Class[] { RedmineRestResource.class };
	}
	
	@Override
	protected Object[] getExtraExtensions() {
		return new Object[]{
				new StepProvider() {
					@Override
					public Class<? extends Step> getStepClass() {
						if (RedmineSetting.get(Context.getConfiguration()) == null) {
							return null;
						} else {
							return CreateIssueStep.class;
						}
					}
				}
			};
	}
}
