package com.pmease.quickbuild.plugin.scm.svn;

import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;

@ScriptApi
public class SvnSetting {
	private String svnExecutablePath;
	
	@Editable(order=100, name="Subversion Executable Path", description=
		"Specify path to Subversion executable. For example: <b>/usr/local/svn</b>"
		)
	@ScriptApi("Get path to Subversion executable. Null if not specified.")
	@Scriptable
	public String getSvnExecutablePath() {
		return svnExecutablePath;
	}

	public void setSvnExecutablePath(String svnExecutablePath) {
		this.svnExecutablePath = svnExecutablePath;
	}
}
