package com.pmease.quickbuild.plugin.report.boosttest;

import java.util.Map;

import com.google.common.collect.ImmutableMap;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.grid.NodeJob;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.xunit.XUnitPublisher;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;

@Editable(category="Publish", name = "Boost Test Report", description = "Publish Boost Test reports")
@ScriptApi("This step publishes the original Boost Test XML files.")
public class BoostTestPublisher extends XUnitPublisher {
	private static final long serialVersionUID = 1L;

	@Override
	protected Class<? extends NodeJob> getChecksumJob() {
		return BoostTestChecksum.class;
	}
	
	public static class BoostTestChecksum extends ChecksumJob {

		@Override
		protected ReportCategory getCategory() {
			return ReportHelper.getCategory(BoostTestPlugin.class);
		}
		
	}
	
	@Override
	protected Map<String, ?> getExtraOverviewData(String reportsetName) {
		return ImmutableMap.<String, Object>builder()
				.put("byTestsUrl", ReportUtils.getReportsetUrl(getBuild(), 
						Tab.title2id(getCategory().getName()), 
						"by_tests", reportsetName))
				.put("failedTestsUrl", ReportUtils.getReportsetUrl(getBuild(), 
						Tab.title2id(getCategory().getName()), 
						"failed_tests", 
						reportsetName))
				.build();
	}
}
