package com.pmease.quickbuild.plugin.report.boosttest;

import com.pmease.quickbuild.aggregationsupport.Aggregation;
import com.pmease.quickbuild.extensionpoint.support.Gadget;
import com.pmease.quickbuild.plugin.report.boosttest.gadget.BoostAggregatedOverviewGadget;
import com.pmease.quickbuild.plugin.report.boosttest.gadget.BoostAggregatedStatsGadget;
import com.pmease.quickbuild.plugin.report.boosttest.gadget.BoostOverviewGadget;
import com.pmease.quickbuild.plugin.report.boosttest.gadget.BoostSummaryGadget;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.xunit.AbstractTestReportPlugin;
import com.pmease.quickbuild.stepsupport.Step;

public class BoostTestPlugin extends AbstractTestReportPlugin {

	@Override
	protected Class<? extends Step> getPublishStepClass() {
		return BoostTestPublisher.class;
	}

	@Override
	protected ReportCategory createCategory() {
		return new BoostTestCategory();
	}

	@Override
	public Class<? extends Aggregation> getAggregatorClass() {
		return BoostAggregator.class;
	}
	
	@Override
	protected Class<?>[] getRestResourceClasses() {
		return new Class<?>[] { BoostTestRest.class };
	}
	
	@SuppressWarnings("unchecked")
	@Override
	protected Class<? extends Gadget>[] getGadgetClasses() {
		return new Class[] {
				BoostOverviewGadget.class,
				BoostSummaryGadget.class,
				BoostAggregatedOverviewGadget.class,
				BoostAggregatedStatsGadget.class
		};
	}
}
