package com.pmease.quickbuild.plugin.notifier.msn;

import org.hibernate.validator.constraints.NotEmpty;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Template;

@Editable(name="MSN Notification Template", category="Notification Template", description=
	"This template will be used to construct MSN messenger build notification message of this configuration " +
	"if necessary. If not specified, template of parent configuration will be used.")
public class MsnNotificationTemplate {
	
	private String content = "#parse (\"default_plain_notification.vm\")";
	
	@Editable(order = 100, description=
		"Specify a <a href=\"http://velocity.apache.org\">Velocity</a> template here. Evaluation " +
		"result of the template will be used as content of the MSN messenger notification. The " +
		"resource load path will be set to the <em>asset</em> sub folder under QuickBuild " +
		"server's installation directory when this template is evaluated. Also refer to template " +
		"context help below for objects contained in the Velocity context.")
	@Multiline(10)
	@NotEmpty
	@ScriptApi("Get template of MSN notify message content.")
	@Template
	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}
}
