/*
 * Copyright PMEase (c) 2005-2008,
 * Date: Feb 24, 2008
 * Time: 4:29:05 PM
 * All rights reserved.
 * 
 * Revision: $$Id: AntSetting.java 1550 2008-10-24 08:24:21Z robin $$ 
 */
package com.pmease.quickbuild.plugin.builder.ant;

import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;

@ScriptApi("Global settings for Ant.")
public class AntSetting {
	
	private String antExecutablePath;
	
	private String antHome;
	
	private String antOptions;

	@Editable(order=50, name="Ant Home", description=
			"Specify Ant Home here if Ant does not exist in your system path or you do not "
			+ "want to use the default Ant. For example: <b>c:\\apache-ant-1.7.0</b>. "
			+ "If specified, this value will be passed as ANT_HOME environment variable when "
			+ "executing Ant builds."
		)
	@Scriptable
	public String getAntHome() {
		return antHome;
	}

	public void setAntHome(String antHome) {
		this.antHome = antHome;
	}

	@Editable(order=100, name="Ant Executable Path", description=
		"Optionally specify path to Ant executable, for example: <b>c:\\apache-ant-1.7.0\\bin\\ant.bat</b>"
		+ " You only need to specify Ant executable if it does not reside under $ANT_HOME/bin. "
		)
	@ScriptApi("Get Ant executable path. Null if not specified.")
	@Scriptable
	public String getAntExecutablePath() {
		return antExecutablePath;
	}

	public void setAntExecutablePath(String antExecutablePath) {
		this.antExecutablePath = antExecutablePath;
	}
	
	@Editable(order=200, name="Ant Global Options", description="Optionally specify Ant " +
			"options for all Ant build steps. Please note that you should NOT specify " +
			"below options as they'll be determined by QuickBuild for step setting:<br>" +
			"<b>-f, -buildfile, -file, -logfile, -l, -quiet, -q, -verbose, -v, -debug, -d, " +
			"-logger, -emacs, -e, -D</b>")
	@Scriptable
	@ScriptApi("Get Ant options")
	public String getAntOptions() {
		return antOptions;
	}

	public void setAntOptions(String antOptions) {
		this.antOptions = antOptions;
	}
	
}
