package com.pmease.quickbuild.plugin.authenticator.ldap;

import org.hibernate.validator.constraints.NotEmpty;

import com.pmease.quickbuild.annotation.Editable;

@Editable(order=100)
public class SearchGroupsUsingFilter extends GroupRetrievalStrategy {
	
	private static final long serialVersionUID = 1L;

	private String groupSearchBase;
	
	private String groupSearchFilter;
	
	@Editable(order=100, description=
		"In case of user group relationship maintained at group side, this property specifies " +
		"base node for group search. For example: <b>ou=groups, dc=example, dc=com.</b><br>" + 
		"<strong>NOTE:</strong> Group search will be performed against the referral LDAP if " +
		"user entry is fetched through referral.")
	@NotEmpty
	public String getGroupSearchBase() {
		return groupSearchBase;
	}

	public void setGroupSearchBase(String groupSearchBase) {
		this.groupSearchBase = groupSearchBase;
	}

	@Editable(order=200, description=
		"In case of user group relationship maintained at group side, this filter is used to " +
		"determine belonging groups of current user. For example: " +
		"<b>(&(uniqueMember={0})(objectclass=groupOfUniqueNames))</b>. In this example, <b>{0}</b> " +
		"represents DN of current user.<br>" +
		"<strong>NOTE:</strong> Group search will be performed against the referral LDAP if " +
		"user entry is fetched through referral.")
	@NotEmpty
	public String getGroupSearchFilter() {
		return groupSearchFilter;
	}

	public void setGroupSearchFilter(String groupSearchFilter) {
		this.groupSearchFilter = groupSearchFilter;
	}
}
