package com.pmease.quickbuild.plugin.authenticator.ldap;

import com.pmease.quickbuild.extensionpoint.AuthenticatorProvider;
import com.pmease.quickbuild.pluginsupport.AbstractPlugin;
import com.pmease.quickbuild.pluginsupport.PluginCategory;
import com.pmease.quickbuild.security.Authenticator;

public class LdapPlugin extends AbstractPlugin {

	@Override
	public Object[] getExtensions() {
		return new Object[]{
				new AuthenticatorProvider() {

					@Override
					public Class<? extends Authenticator> getAuthenticatorClass() {
						return LdapAuthenticator.class;
					}
					
				}, 
				new AuthenticatorProvider() {
					
					@Override
					public Class<? extends Authenticator> getAuthenticatorClass() {
						return ActiveDirectoryAuthenticator.class;
					}
				},
		};
	}

	@Override
	public Class<?> getSettingClass() {
		return null;
	}

	public PluginCategory getCategory() {
		return PluginCategory.SYSTEM;
	}

}
