package com.pmease.quickbuild.plugin.authenticator.ldap;

import java.io.Serializable;

import org.hibernate.validator.constraints.NotEmpty;

import com.pmease.quickbuild.annotation.Editable;

public abstract class GroupRetrievalStrategy implements Serializable {

	private static final long serialVersionUID = 1L;
	
	private String groupNameAttribute;

	@Editable(order=1000, description=
		 "Specifies the group name attribute inside the found group entry. " +
		 "Value of this attribute will be mapped to a QuickBuild group.")
	@NotEmpty
	public String getGroupNameAttribute() {
		return groupNameAttribute;
	}

	public void setGroupNameAttribute(String groupNameAttribute) {
		this.groupNameAttribute = groupNameAttribute;
	}
	
}
