package com.pmease.quickbuild.plugin.authenticator.ldap;

import org.hibernate.validator.constraints.NotEmpty;

import com.pmease.quickbuild.annotation.Editable;

@Editable(order=200)
public class GetGroupsUsingAttribute extends GroupRetrievalStrategy {

	private static final long serialVersionUID = 1L;
	
	private String userGroupsAttribute;

	@Editable(order=100, description=
		"Specifies name of the attribute inside the user entry whose value contains distinguished " + 
        "names of belonging groups.")
    @NotEmpty
	public String getUserGroupsAttribute() {
		return userGroupsAttribute;
	}

	public void setUserGroupsAttribute(String userGroupsAttribute) {
		this.userGroupsAttribute = userGroupsAttribute;
	}
	
}
