package com.pmease.quickbuild.plugin.authenticator.ldap;

import org.hibernate.validator.constraints.NotEmpty;

import com.pmease.quickbuild.annotation.Editable;

@Editable(name="Active Directory", order=100)
public class ActiveDirectoryAuthenticator extends LdapAuthenticator {

	private static final long serialVersionUID = 1L;

	private String groupSearchBase;
	
    @Editable(order=100, name="LDAP URL", description=
    	"Specifies LDAP URL of the Active Directory server, for example: <b>ldap://ad-server:389</b>, or <b>ldaps://ad-server:636</b>.")
    @NotEmpty
	@Override
	public String getLdapUrl() {
		return super.getLdapUrl();
	}

	@Editable(order=300, description=
		"Specifies binding user here to perform LDAP searches, in form of <b>&lt;account name&gt;@&lt;domain&gt;</b>, "
		+ "for instance: <i>quickbuild@example.com</i>. If this property is left as empty, QuickBuild will try to "
		+ "bind anonymously to perform LDAP searches.<br>"
		+ "<strong>NOTE:</strong> <b>{0}</b> contained in this property will be replaced by name of the login user.")
	@Override
	public String getBindUser() {
		return super.getBindUser();
	}

	@Editable(order=500, description=
		"Specifies the base node for user search. For example: <i>cn=Users, dc=example, dc=com</i>")
	@NotEmpty
	@Override
	public String getUserSearchBase() {
		return super.getUserSearchBase();
	}

	@Override
	public String getUserSearchFilter() {
		return "(&(sAMAccountName={0})(objectclass=user))";
	}

	@Override
	public String getUserFullNameAttribute() {
		return "displayName";
	}

	@Override
	public String getUserEmailAttribute() {
		return "mail";
	}

	@Editable(order=1000, description="Optionally specify group search base to search groups associated with user, "
			+ "for instance: <i>cn=Users, dc=example, dc=com</i>"
			+ "If not specified, the default group defined below will be associated with the user.")
	public String getGroupSearchBase() {
		return groupSearchBase;
	}

	public void setGroupSearchBase(String groupSearchBase) {
		this.groupSearchBase = groupSearchBase;
	}

	@Override
	public GroupRetrievalStrategy getGroupRetrievalStrategy() {
		if (getGroupSearchBase() != null) {
			SearchGroupsUsingFilter strategy = new SearchGroupsUsingFilter();
			strategy.setGroupNameAttribute("cn");
			strategy.setGroupSearchBase(getGroupSearchBase());
			strategy.setGroupSearchFilter("(&(member={0})(objectclass=group))");
			return strategy;
		} else {
			return new DoNotRetrieveGroups();
		}
	}

}
