package com.pmease.quickbuild.plugin.artifact;

import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;

@SuppressWarnings("serial")
public class ArtifactSummaryPanel extends Panel {

	public ArtifactSummaryPanel(String panelId) {
		super(panelId);
		
		add(new ArtifactPanel("content") {

			@Override
			protected Component newTreeHeader(String id) {
				Fragment fragment = new Fragment(id, "headerFrag", ArtifactSummaryPanel.this);
				fragment.add(new WebMarkupContainer("download") {

					@Override
					protected void onComponentTag(ComponentTag tag) {
						super.onComponentTag(tag);
						tag.put("href", Context.getConfiguration().findArtifactStorage().getBatchSupport().getUrl(
								Context.getBuild(), Build.ARTIFACT_DIR, "**"));
					}

					@Override
					protected void onConfigure() {
						super.onConfigure();
						setVisible(Context.getConfiguration().findArtifactStorage().getBatchSupport() != null 
								&& SecurityHelper.hasPermission(Context.getConfiguration(), ConfigurationPermission.BATCH_DOWNLOAD_ARTIFACTS.name()));
					}
					
				});
				return fragment;
			}
			
		});
	}

}
