/*
 * Copyright PMEase (c) 2005-2008,
 * Date: Feb 24, 2008
 * Time: 4:29:05 PM
 * All rights reserved.
 * 
 * Revision: $$Id: ArtifactPlugin.java 1645 2008-11-05 03:45:52Z robin $$ 
 */
package com.pmease.quickbuild.plugin.artifact;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.apache.wicket.markup.html.panel.Panel;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.extensionpoint.ArtifactStorageProvider;
import com.pmease.quickbuild.extensionpoint.BuildOverviewContribution;
import com.pmease.quickbuild.extensionpoint.BuildSummaryContribution;
import com.pmease.quickbuild.extensionpoint.GadgetProvider;
import com.pmease.quickbuild.extensionpoint.StepProvider;
import com.pmease.quickbuild.extensionpoint.support.Gadget;
import com.pmease.quickbuild.extensionpoint.support.PanelCreator;
import com.pmease.quickbuild.pluginsupport.AbstractPlugin;
import com.pmease.quickbuild.pluginsupport.PluginCategory;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.setting.configuration.artifactstorage.ArtifactStorage;
import com.pmease.quickbuild.setting.configuration.artifactstorage.ServerArtifactStorage;
import com.pmease.quickbuild.stepsupport.Step;

public class ArtifactPlugin extends AbstractPlugin {
	
	private static final int order = 10;
	
	@Override
	public Object[] getExtensions() {
		return new Object[] {
			new StepProvider() {

				@Override
				public Class<? extends Step> getStepClass() {
					return ArtifactPublishStep.class;
				}

			}, 
			new ArtifactStorageProvider() {

				@Override
				public Class<? extends ArtifactStorage> getArtifactStorageClass() {
					return ServerArtifactStorage.class;
				}
				
			},
			new ArtifactStorageProvider() {

				@Override
				public Class<? extends ArtifactStorage> getArtifactStorageClass() {
					return AgentArtifactStorage.class;
				}
				
			},
			new ArtifactCleanupTask(),
			new BuildOverviewContribution() {

				public int getOrder() {
					return order;
				}

				public List<PanelCreator> getPanelCreators() {
					List<PanelCreator> providers = new ArrayList<PanelCreator>();
					
					if (SecurityHelper.hasPermission(ConfigurationPermission.ACCESS_ARTIFACTS.name())
							|| Context.getBuild().isRecommended() && SecurityHelper.hasPermission(ConfigurationPermission.ACCESS_RECOMMENDED_ARTIFACTS.name())) {
						if (Context.getBuild().getArtifactsDir().exists()) {
							providers.add(new PanelCreator() {
	
								public Panel newPanel(String panelId) {
									return new ArtifactOverviewPanel(panelId);
								}
								
							});
						}
						ExternalArtifactSetting artifactSetting = (ExternalArtifactSetting) findConfigurationSetting(Context.getConfiguration(), true);
						if (artifactSetting != null) {
							final File externalArtifactsDir = new File(artifactSetting.getExternalDirectory());
							if (externalArtifactsDir.exists()) {
								providers.add(new PanelCreator() {
	
									@Override
									public Panel newPanel(String id) {
										return new ExternalArtifactOverviewPanel(id, externalArtifactsDir);
									}
									
								});
							}
						}
					}
					return providers;
				}

			}, 
			new BuildSummaryContribution() {

				public List<PanelCreator> getPanelCreators() {
					List<PanelCreator> providers = new ArrayList<PanelCreator>();
					if (SecurityHelper.hasPermission(ConfigurationPermission.ACCESS_ARTIFACTS.name())
							|| Context.getBuild().isRecommended() && SecurityHelper.hasPermission(ConfigurationPermission.ACCESS_RECOMMENDED_ARTIFACTS.name())) {					
						if (Context.getBuild().getArtifactsDir().exists()) {
							providers.add(new PanelCreator() {
	
								public Panel newPanel(String panelId) {
									return new ArtifactSummaryPanel(panelId);
								}
								
							});
						}
						ExternalArtifactSetting artifactSetting = (ExternalArtifactSetting) findConfigurationSetting(Context.getConfiguration(), true);
						if (artifactSetting != null) {
							final File externalArtifactsDir = new File(artifactSetting.getExternalDirectory());
							if (externalArtifactsDir.exists()) {
								providers.add(new PanelCreator() {
	
									@Override
									public Panel newPanel(String id) {
										return new ExternalArtifactSummaryPanel(id, externalArtifactsDir);
									}
									
								});
							}
					}
					}
					return providers;
				}

				public int getOrder() {
					return order;
				}

			},
			new GadgetProvider() {

				@Override
				public Class<? extends Gadget> getGadgetClass() {
					return ArtifactGadget.class;
				}
				
			},
			new GadgetProvider() {

				@Override
				public Class<? extends Gadget> getGadgetClass() {
					return ExternalArtifactGadget.class;
				}
				
			}
		};
	}

	@Override
	public Class<?> getConfigurationSettingClass() {
		return ExternalArtifactSetting.class;
	}

	public PluginCategory getCategory() {
		return PluginCategory.SYSTEM;
	}

}