/*
 * Copyright PMEase (c) 2005 - 2009,
 * Date: Jun 4, 2009 4:19:55 PM
 * All rights reserved.
 * 
 * Revision: $Id$
 * 
 */

package com.pmease.quickbuild.plugin.artifact;

import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;

@SuppressWarnings("serial")
public class ArtifactOverviewPanel extends Panel {

	public ArtifactOverviewPanel(String panelId) {
		super(panelId);
		
		add(new WebMarkupContainer("download") {

			@Override
			protected void onComponentTag(ComponentTag tag) {
				super.onComponentTag(tag);
				tag.put("href", Context.getConfiguration().findArtifactStorage().getBatchSupport().getUrl(Context.getBuild(), Build.ARTIFACT_DIR, "**"));
			}

			@Override
			protected void onConfigure() {
				super.onConfigure();
				setVisible(Context.getConfiguration().findArtifactStorage().getBatchSupport() != null 
						&& SecurityHelper.hasPermission(ConfigurationPermission.BATCH_DOWNLOAD_ARTIFACTS.name()));
			}
			
		});

		add(new ArtifactPanel("content"));
	}
}
