package com.pmease.quickbuild.plugin.artifact;

import org.apache.wicket.markup.html.panel.Panel;

import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.extensionpoint.support.BuildBasedGadget;
import com.pmease.quickbuild.extensionpoint.support.GadgetCategory;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;

@Editable(name="Published Artifacts", category=GadgetCategory.ARTIFACTS_AND_HTML_REPORTS)
public class ArtifactGadget extends BuildBasedGadget {

	private static final long serialVersionUID = 1L;

	@Override
	protected Panel renderBodyForBuild(String panelId) {
		if (SecurityHelper.hasPermission(ConfigurationPermission.ACCESS_ARTIFACTS.name()) 
				|| Context.getBuild().isRecommended() && SecurityHelper.hasPermission(ConfigurationPermission.ACCESS_RECOMMENDED_ARTIFACTS.name())) {
			return new ArtifactPanel(panelId);
		} else {
			throw new AccessDeniedException("You do not have permission to " +
					"access artifacts of configuration '" + Context.getConfiguration() + "'.");
		}
	}

}
