package com.example.promptbean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.validation.constraints.NotNull;

import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Choices;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.web.component.editor.EditContext.EditableProperty;

/**
 * This bean will be presented to collect a variable input if the variable is set to 
 * prompt for input of this bean. To use the variable, call vars.get("<var name>").asBean() 
 * to convert the variable value to object of this class, and then you can traverse the 
 * object graph with MVEL or Groovy to get anything you want. 
 *  
 * @author robin
 *
 */
@Editable(name="Example Prompt Bean")
public class TestSetting implements Serializable {
	
	private static final long serialVersionUID = 1L;

	private TestMode testMode;
	
	private String testSuite;
	
	private String testCase;
	
	/**
	 * Upon interface or abstract class, QuickBuild will present a selection box with 
	 * choices of all its implementations found in the same package. 
	 * @return
	 */
	@Editable(order=100)
	@NotNull
	public TestMode getTestMode() {
		return testMode;
	}

	/**
	 * Do not forget the setter method, otherwise the field will not be editable
	 * @param testMode
	 */
	public void setTestMode(TestMode testMode) {
		this.testMode = testMode;
	}

	@Editable(order=200, description="Optionally specify the test suite to run. Left empty " +
			"to run all test suites.")
	@Choices({"testsuite1", "testsuite2", "testsuite3"})
	public String getTestSuite() {
		return testSuite;
	}

	public void setTestSuite(String testSuite) {
		this.testSuite = testSuite;
	}
	
	@Editable(order=300, description="Optionally specify te test case to run. Left empty " +
			"to run all test cases in specified test suite.")
	@ChoiceProvider("getTestCaseChoices")
	public String getTestCase() {
		return testCase;
	}

	public void setTestCase(String testCase) {
		this.testCase = testCase;
	}

	@SuppressWarnings("unused")
	private static List<String> getTestCaseChoices() {
		List<String> testCases = new ArrayList<String>();
		
		/* 
		 * Available test cases are determined by selected test suite. Below code demonstrates 
		 * how to populate the list based on selected test suite. Please note that to get 
		 * current value of another property being edited, one has to call 
		 * EditableProperty.getValueAsString("<property name>").
		 */
		String testSuite = EditableProperty.getValueAsString("testSuite");
		if (testSuite != null) {
			for (int i=1; i<9; i++) 
				testCases.add("testcase" + i + " of " + testSuite);
		}
		return testCases;
	}
}
