package com.example.promptbean;

import java.util.List;

import javax.validation.constraints.Size;

import com.pmease.quickbuild.annotation.Choices;
import com.pmease.quickbuild.annotation.Editable;

@Editable(name="Smoke Test", order=100)
public class SmokeTestMode implements TestMode {
	
	private static final long serialVersionUID = 1L;
	
	private List<String> components;
	
	private boolean runIntegrationTests;
	
	@Editable(order=100, description="Select components for smoke test.")
	@Choices({"Component A", "Component B"})
	@Size(min=1)
	public List<String> getComponents() {
		return components;
	}

	public void setComponents(List<String> components) {
		this.components = components;
	}

	@Editable(order=200, description="Whether or not to run integration tests.")
	public boolean isRunIntegrationTests() {
		return runIntegrationTests;
	}

	public void setRunIntegrationTests(boolean runIntegrationTests) {
		this.runIntegrationTests = runIntegrationTests;
	}

}
