package com.example.myplugin;

import java.util.Map;

import org.apache.wicket.markup.html.panel.Panel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

import com.pmease.quickbuild.web.chart.JFreeChartPanel;

public class MyStatisticsPanel extends Panel {

	private static final long serialVersionUID = 1L;

	public MyStatisticsPanel(String id, MyStatistics stats) {
		super(id);

		DefaultCategoryDataset dataset = new DefaultCategoryDataset();
		for (Map.Entry<String, Integer> entry: stats.getMsgLens().entrySet()) 
			dataset.addValue(entry.getValue(), "", entry.getKey());
		
		JFreeChart chart = ChartFactory.createLineChart("Message Char Count Statistics", 
				"build", "count", dataset, PlotOrientation.VERTICAL, 
				false, false, false);
		add(new JFreeChartPanel("chart", 800, 400, chart));
	}

}
