package com.example.myplugin;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;

import org.apache.wicket.markup.html.panel.Panel;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.extensionpoint.BuildOverviewContribution;
import com.pmease.quickbuild.extensionpoint.StatisticsTabContribution;
import com.pmease.quickbuild.extensionpoint.StepProvider;
import com.pmease.quickbuild.extensionpoint.support.PanelCreator;
import com.pmease.quickbuild.pluginsupport.AbstractPlugin;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.LockUtils;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;

public class MyPlugin extends AbstractPlugin {

	/*
	@Override
	public Class<?> getSettingClass() {
		return MyPluginSetting.class;
	}
	*/

	@Override
	public Class<?> getConfigurationSettingClass() {
		return MyPluginSetting.class;
	}

	@Override
	public Object[] getExtensions() {
		return new Object[] {
			new StepProvider() {

				@Override
				public Class<? extends Step> getStepClass() {
					return MyStep.class;
				}
				
			}, 
			new StepProvider() {

				@Override
				public Class<? extends Step> getStepClass() {
					return MyAnotherStep.class;
				}
				
			}, 
			new BuildOverviewContribution() {
				
				public List<PanelCreator> getPanelCreators() {
					List<PanelCreator> creators = new ArrayList<PanelCreator>();
					if (new File(Context.getBuild().getPublishDir(), "myplugin").exists()) {
						creators.add(new PanelCreator() {
	
							public Panel newPanel(String id) {
								return new MyPanel(id);
							}
							
						});
					}
					return creators;
				}
				
				public int getOrder() {
					return 500;
				}
			}, 
			new MyMetricsCollector(), 
			new StatisticsTabContribution() {
				
				private static final long serialVersionUID = 1L;

				public List<Tab> getTabs() {
					List<Tab> tabs = new ArrayList<Tab>();
					File statsDir = new File(Context.getConfiguration().getPublishDir(), "myplugin");
					Lock lock = LockUtils.lockForRead(statsDir);
					try {
						if (statsDir.exists()) {
							File statsFile = new File(statsDir, "statistics.xml");
							final MyStatistics stats = (MyStatistics) BeanUtils.readFile(statsFile);
							
							tabs.add(new Tab("message char count") {

								private static final long serialVersionUID = 1L;

								@Override
								public Panel getPanel(String id, Map<String, String> params) {
									return new MyStatisticsPanel(id, stats);
								}
								
							});
						}
					} finally {
						lock.unlock();
					}
					return tabs;
				}
				
				public int getOrder() {
					return 500;
				}
			}, 
		};
	}
}