package com.example.myplugin;

import java.io.File;

import org.hibernate.validator.constraints.NotEmpty;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.FileUtils;

@Editable(category="examples", name="publish message", description=
	"This step publishes an user defined message and render them on build overview screen.")
public class MyAnotherStep extends Step {

	private static final long serialVersionUID = 1L;
	
	private String message;

	@Editable
	@NotEmpty
	@Scriptable
	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	@Override
	public void run() {
		File tempDir = FileUtils.createTempDir("myanotherstep");
		try {
			FileUtils.writeFile(new File(tempDir, "message.txt"), getMessage());
			Context.getBuild().publish(tempDir.getAbsolutePath(), "**", "myplugin");
		} finally {
			FileUtils.deleteDir(tempDir);
		}
	}

}
