package com.example.javancss.web;

import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;

import com.example.javancss.Metrics;
import com.pmease.quickbuild.web.page.build.BuildPage;

public class MetricsSummaryPanel extends Panel {

	private static final long serialVersionUID = 1L;

	public MetricsSummaryPanel(String id, Long buildId, Metrics metrics) {
		super(id);

		Link<?> link = new BookmarkablePageLink<Void>("link", 
				BuildPage.class, BuildPage.params4(buildId, new String[]{"javancss"}));
		link.add(new Label("label", "source lines: " + metrics.getSourceLines() + 
				", comment lines: " + metrics.getCommentLines()));
		add(link);
	}

}
