package com.example.javancss.web;

import org.apache.wicket.markup.html.panel.Panel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;

import com.pmease.quickbuild.web.chart.JFreeChartPanel;

public class MetricsStatisticsPanel extends Panel {

	private static final long serialVersionUID = 1L;

	public MetricsStatisticsPanel(String id, CategoryDataset dataset, String rangeAxisLabel) {
		super(id);

		JFreeChart chart =  ChartFactory.createStackedBarChart("LOC", rangeAxisLabel, "Lines", dataset,   
				PlotOrientation.VERTICAL,  true,  true,  false);

		add(new JFreeChartPanel("chart", 800, 200, chart));
	}

}
