package com.example.javancss.web;

import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.data.general.DefaultPieDataset;

import com.example.javancss.Metrics;
import com.pmease.quickbuild.web.chart.JFreeChartPanel;

public class AggregatedMetricsPanel extends Panel {

	private static final long serialVersionUID = 1L;

	public AggregatedMetricsPanel(String id, String title, Metrics metrics) {
		super(id);

		add(new Label("title", title));
		
		DefaultPieDataset dataset = new DefaultPieDataset();
		dataset.setValue("Source Lines", metrics.getSourceLines());
		dataset.setValue("Comments Lines", metrics.getCommentLines());

		JFreeChart chart = ChartFactory.createPieChart("LOC", dataset,
				true, true, false);  		
		add(new JFreeChartPanel("chart", 800, 200, chart));
	}

}
