package com.example.javancss;

import org.hibernate.validator.constraints.Range;

import com.pmease.quickbuild.annotation.Editable;

public class PluginSetting {
	
	private int commentThreshold;

	@Editable(order=100, description=
		"Specify comment threshold in the range of 0 to 100. The JavaNCSS checking will fail if percent " +
		"of comments is less than this threshold.")
	@Range(min=0, max=100)
	public int getCommentThreshold() {
		return commentThreshold;
	}

	public void setCommentThreshold(int commentThreshold) {
		this.commentThreshold = commentThreshold;
	}
	
}
