#! /bin/sh

JAVACMD=java

# Get the fully qualified path to the script
case $0 in
    /*)
        SCRIPT="$0"
        ;;
    *)
        PWD=`pwd`
        SCRIPT="$PWD/$0"
        ;;
esac

# Resolve the true real path without any sym links.
CHANGED=true
while [ "X$CHANGED" != "X" ]
do
    # Change spaces to ":" so the tokens can be parsed.
    SAFESCRIPT=`echo $SCRIPT | sed -e 's; ;:;g'`
    # Get the real path to this script, resolving any symbolic links
    TOKENS=`echo $SAFESCRIPT | sed -e 's;/; ;g'`
    REALPATH=
    for C in $TOKENS; do
        # Change any ":" in the token back to a space.
        C=`echo $C | sed -e 's;:; ;g'`
        REALPATH="$REALPATH/$C"
        # If REALPATH is a sym link, resolve it.  Loop for nested links.
        while [ -h "$REALPATH" ] ; do
            LS="`ls -ld "$REALPATH"`"
            LINK="`expr "$LS" : '.*-> \(.*\)$'`"
            if expr "$LINK" : '/.*' > /dev/null; then
                # LINK is absolute.
                REALPATH="$LINK"
            else
                # LINK is relative.
                REALPATH="`dirname "$REALPATH"`""/$LINK"
            fi
        done
    done

    if [ "$REALPATH" = "$SCRIPT" ]
    then
        CHANGED=""
    else
        SCRIPT="$REALPATH"
    fi
done

# Change the current directory to the location of the script
cd "`dirname "$REALPATH"`"

"$JAVACMD" -version
if [ "$?" = "0" ]
then
    echo ===========================================================
    "$JAVACMD" -Xmx1024m -classpath ../plugins/com.pmease.quickbuild.bootstrap:../plugins/com.pmease.quickbuild.bootstrap/lib/joda-time-2.7.jar:../plugins/com.pmease.quickbuild.bootstrap/lib/wrapper.jar:../plugins/com.pmease.quickbuild.bootstrap/lib/slf4j-api-1.7.2.jar:../plugins/com.pmease.quickbuild.bootstrap/lib/jul-to-slf4j-1.7.2.jar:../plugins/com.pmease.quickbuild.bootstrap/lib/log4j-1.2.15.jar:../plugins/com.pmease.quickbuild.bootstrap/lib/commons-codec-1.10.jar:../plugins/com.pmease.quickbuild.bootstrap/lib/hessian-4.0.38.jar:../plugins/com.pmease.quickbuild.bootstrap/lib/commons-logging-1.0.4.jar:../plugins/com.pmease.quickbuild.bootstrap/lib/servlet-api-3.0.20100224.jar:../plugins/com.pmease.quickbuild.bootstrap/lib/slf4j-log4j12-1.7.2.jar:../plugins/com.pmease.quickbuild.bootstrap/lib/commons-io-1.4.jar:../plugins/com.pmease.quickbuild.bootstrap/lib/commons-lang-2.4.jar com.pmease.quickbuild.bootstrap.Restore $1
else
    echo Please make sure java command exists in PATH
fi    