	function hideAll() {
		$('#$gridId .showhide').removeClass('expanded').addClass('collapsed').html('&raquo; Show detailed messages');
		$('#$gridId .details').hide();
		$('#$gridId .section-header').removeClass('expanded').addClass('collapsed');
		$('#$gridId .showhide-trigger').removeClass('expanded').addClass('collapsed');
	}
	
	function showAll() {
		$('#$gridId .showhide').removeClass('collapsed').addClass('expanded').html('&laquo; Show names only');
		$('#$gridId .section-header').removeClass('collapsed').addClass('expanded');
		$('#$gridId .showhide-trigger').removeClass('collapsed').addClass('expanded');
		$('#$gridId .details').show();
	}
	
	$('#$gridId .showhide').bind('click', function() {
		if ($(this).hasClass('expanded')) {
			hideAll();
		} else {
			showAll();
		}
	});
	
	$('#$gridId .showhide-trigger').bind('click', function() {
		var sectionHeader = $(this).parents('.section-header:first');
		var detailsTable = sectionHeader.siblings();
		if ($(this).hasClass('expanded')) {
			$(this).removeClass('expanded').addClass('collapsed');
			sectionHeader.removeClass('expanded').addClass('collapsed');
			detailsTable.hide();
		} else {
			$(this).removeClass('collapsed').addClass('expanded');
			sectionHeader.removeClass('collapsed').addClass('expanded');
			detailsTable.show();
		}
	});
	
	function adjustWidthOfMsg() {
		var spanWidth = $('#$emptySpan').width();
		if (spanWidth == 0) {
			spanWidth = 566; // width of emptySpan in default popup dialog
		}
		var width = spanWidth - 150;
		$('#$gridId .stacktrace .msg').css({'width': width + "px", 'overflow': 'auto'});
	};
	
	$(window).resize(function() {
		adjustWidthOfMsg();
	});
	
	adjustWidthOfMsg();
